/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.workstream.business.impl;

import com.freiheit.toro.common.shared.model.InvalidIdServiceException;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.album.business.AlbumService;
import de.justsoftware.onx.album.shared.model.AlbumId;
import de.justsoftware.onx.common.business.InvalidIDException;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.model.StartpageId;
import de.justsoftware.onx.common.shared.server.TransactionHelper;
import de.justsoftware.onx.container.shared.model.GlobalId;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.drive.shared.model.DriveDocumentId;
import de.justsoftware.onx.drive.shared.model.DriveTempId;
import de.justsoftware.onx.link.business.LinkService;
import de.justsoftware.onx.videolink.business.VideolinkService;
import de.justsoftware.onx.videolink.shared.model.DBVideolink;
import de.justsoftware.onx.videolink.shared.model.VideolinkId;
import de.justsoftware.onx.workstream.business.impl.DriveDocumentAttachmentCreator;
import de.justsoftware.onx.workstream.shared.model.WorkstreamMessageId;
import de.justsoftware.onx.workstream.shared.model.attachments.Attachment;
import de.justsoftware.onx.workstream.shared.model.attachments.AttachmentVisitor;
import de.justsoftware.onx.workstream.shared.model.attachments.DriveDocumentAttachment;
import de.justsoftware.onx.workstream.shared.model.attachments.ExternalLinkAttachment;
import de.justsoftware.onx.workstream.shared.model.attachments.ImageAttachment;
import de.justsoftware.onx.workstream.shared.model.attachments.InternalLinkAttachment;
import de.justsoftware.onx.workstream.shared.model.attachments.LinkAttachment;
import de.justsoftware.onx.workstream.shared.model.attachments.MailToLinkAttachment;
import de.justsoftware.onx.workstream.shared.model.attachments.PollAttachment;
import de.justsoftware.onx.workstream.shared.model.attachments.VideoLinkAttachment;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttachmentSavingVisitor
implements AttachmentVisitor<Attachment> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AttachmentSavingVisitor.class);
    private final AlbumService _albumService;
    private final VideolinkService _videolinkService;
    private final LinkService _linkService;
    private final PersonId _uploader;
    private final ItemId _parentId;
    private final WorkstreamMessageId _messageId;
    private final TransactionHelper _transactionHelper;
    private final DriveDocumentAttachmentCreator _driveAttachmentCreator;

    @ParametersAreNonnullByDefault
    AttachmentSavingVisitor(WorkstreamMessageId messageId, AlbumService albumService, VideolinkService videolinkService, LinkService linkService, PersonId uploader, @Nullable ItemId parentId, TransactionHelper transactionHelper, DriveDocumentAttachmentCreator driveAttachmentCreator) {
        this._albumService = albumService;
        this._videolinkService = videolinkService;
        this._linkService = linkService;
        this._uploader = uploader;
        this._parentId = parentId;
        this._messageId = messageId;
        this._transactionHelper = transactionHelper;
        this._driveAttachmentCreator = driveAttachmentCreator;
    }

    @Override
    public ImageAttachment visit(ImageAttachment attachment) {
        return (ImageAttachment)this._transactionHelper.doInTransaction(status -> {
            try {
                AlbumId albumId = this._albumService.getOrCreateDefaultAlbum(this._parentId).getId();
                attachment.setId(this._albumService.insertDBImage(albumId, "", attachment.getUrl(), this._uploader, false));
                return attachment;
            }
            catch (InvalidIDException e) {
                throw new InvalidIdServiceException(e.getMessage());
            }
        });
    }

    @Override
    public InternalLinkAttachment visit(InternalLinkAttachment linkAttachment) {
        return this.visitLinkAttachment(linkAttachment);
    }

    @Override
    public ExternalLinkAttachment visit(ExternalLinkAttachment linkAttachment) {
        return this.visitLinkAttachment(linkAttachment);
    }

    @Override
    public MailToLinkAttachment visit(MailToLinkAttachment mailToLinkAttachment) {
        return this.visitLinkAttachment(mailToLinkAttachment);
    }

    @Nonnull
    private <L extends LinkAttachment> L visitLinkAttachment(@Nonnull L link) {
        link.setId(this._linkService.saveLink(link.getUrl(), link.getRawTitle()));
        return link;
    }

    @Override
    public VideoLinkAttachment visit(VideoLinkAttachment videoLinkAttachment) {
        ItemId parentId;
        ItemId itemId = parentId = this._parentId instanceof StartpageId ? ((StartpageId)this._parentId).asPersonId().asProfileId() : this._parentId;
        if (!(parentId instanceof GlobalId)) {
            throw new UnsupportedOperationException("videolinks have to be attached to global ids: " + parentId);
        }
        DBVideolink link = new DBVideolink();
        link.setParentId((GlobalId)parentId);
        link.setTitle(videoLinkAttachment.getVideolink().getTitle());
        link.setUrl(videoLinkAttachment.getVideolink().getUrl());
        link.setAuthorId(this._uploader);
        try {
            VideolinkId id = this._videolinkService.insertVideolink(link, false, true);
            videoLinkAttachment.getVideolink().setId(id);
        }
        catch (InvalidIDException e) {
            LOGGER.error("could not save video link attachment", (Throwable)e);
        }
        return videoLinkAttachment;
    }

    @Override
    public DriveDocumentAttachment visit(DriveDocumentAttachment driveAttachment) {
        DriveTempId tempId = driveAttachment.getTempId();
        if (tempId == null) {
            if (driveAttachment.getId() != null) {
                return driveAttachment;
            }
            throw new IllegalArgumentException("missing tempId for drive attachment");
        }
        UUID tempUUID = tempId.getUUID();
        ImmutableMap<UUID, DriveDocumentId> resultMap = this._driveAttachmentCreator.attachTempFilesToWorkstreamItem((Set<UUID>)ImmutableSet.of((Object)tempUUID), this._messageId, this._uploader, this._parentId);
        DriveDocumentId driveDocumentId = (DriveDocumentId)resultMap.get((Object)tempUUID);
        if (driveDocumentId != null) {
            driveAttachment.setId(driveDocumentId);
        }
        return driveAttachment;
    }

    @Override
    public Attachment visit(PollAttachment pollAttachment) {
        return pollAttachment;
    }
}

