/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.workstream.business;

import com.freiheit.toro.common.shared.model.ServiceException;
import com.freiheit.toro.common.shared.model.ValidationException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContextWithLocale;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContextWithUserId;
import de.justsoftware.onx.authorization.business.SearchAuthorizationCheckContext;
import de.justsoftware.onx.common.business.events.util.ServerEventCollector;
import de.justsoftware.onx.common.deletion.DeletionContext;
import de.justsoftware.onx.common.shared.model.JCMediaContentId;
import de.justsoftware.onx.container.business.EntityModuleHandler;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.container.shared.model.ValueTooLargeException;
import de.justsoftware.onx.container.shared.server.model.Item;
import de.justsoftware.onx.workstream.shared.model.DBWorkstreamMessage;
import de.justsoftware.onx.workstream.shared.model.PinnedWorkstream;
import de.justsoftware.onx.workstream.shared.model.Workstream;
import de.justsoftware.onx.workstream.shared.model.WorkstreamFilterId;
import de.justsoftware.onx.workstream.shared.model.WorkstreamFilterModel;
import de.justsoftware.onx.workstream.shared.model.WorkstreamMessageId;
import de.justsoftware.onx.workstream.shared.model.WorkstreamMessageType;
import de.justsoftware.onx.workstream.shared.model.messages.ActivityWorkstreamMessage;
import de.justsoftware.onx.workstream.shared.model.messages.MicroblogPostingCreateModel;
import de.justsoftware.onx.workstream.shared.model.messages.MicroblogPostingEditModel;
import de.justsoftware.onx.workstream.shared.model.messages.WorkstreamMessage;
import de.justsoftware.onx.workstream.shared.server.model.MessagesAndCount;
import java.util.Date;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.joda.time.DateTime;

@ParametersAreNonnullByDefault
public interface WorkstreamService
extends EntityModuleHandler {
    public static final int DEFAULT_WORKSTREAM_OBJECT_COUNT = 10;

    @CheckForNull
    public WorkstreamMessageId addMessageToStream(ActivityWorkstreamMessage var1, AuthorizationCheckContextWithLocale var2);

    @Nonnull
    public MessagesAndCount getStream(ItemId var1, boolean var2, @Nullable Date var3, int var4, WorkstreamFilterModel var5, @Nullable Date var6, SearchAuthorizationCheckContext var7);

    @Nonnull
    public WorkstreamMessageId postToMicroblog(MicroblogPostingCreateModel var1, AuthorizationCheckContextWithUserId var2) throws ValueTooLargeException, ServiceException, ValidationException;

    @CheckForNull
    public WorkstreamMessage getMessage(WorkstreamMessageId var1, AuthorizationCheckContextWithLocale var2);

    @Nonnull
    public ImmutableMap<WorkstreamMessageId, WorkstreamMessage> getMessages(Set<WorkstreamMessageId> var1, AuthorizationCheckContextWithLocale var2);

    @CheckForNull
    public Boolean isOriginPubliclyVisible(ItemId var1, AuthorizationCheckContextWithLocale var2);

    @Nonnull
    public ImmutableList<WorkstreamMessage> getMessages(Iterable<DBWorkstreamMessage> var1, AuthorizationCheckContextWithLocale var2);

    @Nonnull
    public ImmutableMap<WorkstreamMessageId, DBWorkstreamMessage> getWorkstreamEntries(Set<WorkstreamMessageId> var1);

    public void deleteMessage(WorkstreamMessageId var1, AuthorizationCheckContextWithUserId var2);

    public void deleteDependentMessages(Set<WorkstreamMessageId> var1, DeletionContext var2);

    @Nonnull
    public Workstream getWorkstreamForMobile(Item<? extends ItemId> var1, @Nullable Date var2, int var3, boolean var4, SearchAuthorizationCheckContext var5);

    @Nonnull
    public Workstream getWorkstream(Item<? extends ItemId> var1, @Nullable Date var2, int var3, @Nullable WorkstreamFilterId var4, @Nullable Boolean var5, SearchAuthorizationCheckContext var6);

    @Nonnull
    public Workstream getScheduledWorkstream(Item<? extends ItemId> var1, int var2, SearchAuthorizationCheckContext var3);

    @Nonnull
    public ImmutableList<WorkstreamMessage> getWorkstreamForNewsZoom(Set<ItemId> var1, int var2, @Nullable Boolean var3, SearchAuthorizationCheckContext var4);

    @Nonnull
    public PinnedWorkstream getPinnedWorkstream(Item<? extends ItemId> var1, @Nullable Date var2, int var3, SearchAuthorizationCheckContext var4);

    public void updatePinned(WorkstreamMessageId var1, boolean var2, AuthorizationCheckContextWithUserId var3);

    @Nonnull
    public Date hidePinnedWorkstream(ItemId var1, AuthorizationCheckContextWithUserId var2);

    public void unhidePinnedWorkstream(ItemId var1, AuthorizationCheckContextWithUserId var2);

    @Nonnull
    public String getStringForMessage(WorkstreamMessage var1, String var2);

    @CheckForNull
    public WorkstreamMessageId getWorkstreamEntryIdByAttachment(ItemId var1);

    @Nonnull
    public ImmutableMap<ItemId, WorkstreamMessageId> getWorkstreamEntryIdsByAttachments(Set<? extends ItemId> var1);

    @Nonnull
    public ImmutableMap<ItemId, WorkstreamMessageId> getMicroblogEntryIdsByAttachments(Set<? extends ItemId> var1);

    @Nonnull
    public ImmutableList<JCMediaContentId> getOtherAttachmentsOnSameWorkstreamEntry(JCMediaContentId var1);

    @Nonnull
    public ImmutableSet<WorkstreamMessageId> getWorkstreamMessageIdsByOrigins(Set<? extends ItemId> var1);

    @Nonnull
    public ImmutableSet<WorkstreamMessageId> getWorkstreamMessageIdsByAttributes(Set<? extends ItemId> var1);

    @Nonnull
    public ImmutableListMultimap<WorkstreamMessageId, ItemId> getAttachedItems(Set<WorkstreamMessageId> var1);

    @Nonnull
    public ImmutableSet<WorkstreamMessageId> getAllNewMessagesByOthersSince(Item<? extends ItemId> var1, Date var2, SearchAuthorizationCheckContext var3);

    @Nonnull
    public ImmutableMap<WorkstreamMessageId, Date> getNewMicroblogMessagesSince(Item<? extends ItemId> var1, @Nullable Date var2, SearchAuthorizationCheckContext var3);

    public void detachAttachment(WorkstreamMessageId var1, ItemId var2, ServerEventCollector var3);

    @CheckForNull
    public DateTime getNewestMessageDateForUser(Item<? extends ItemId> var1, SearchAuthorizationCheckContext var2);

    @Nonnull
    public ImmutableMap<ItemId, DateTime> getNewestWorkstreamMessageDates(Iterable<? extends Item<? extends ItemId>> var1);

    public boolean keepMessageWithNoAttachments(WorkstreamMessageType var1);

    public void publishScheduledMicroblogPostings();

    @Nonnull
    public ImmutableMap<WorkstreamMessageId, Date> getScheduledPublishDatesForMessages(Set<WorkstreamMessageId> var1);

    public void editMicroblogPosting(MicroblogPostingEditModel var1, AuthorizationCheckContextWithUserId var2) throws ValidationException;
}

