/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.workstream.business;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.common.deletion.DeleteTransactionCallback;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.workstream.business.WorkstreamTypeAttributeValue;
import de.justsoftware.onx.workstream.business.model.WorkstreamMessagePublishedStateFilter;
import de.justsoftware.onx.workstream.shared.model.DBWorkstreamMessage;
import de.justsoftware.onx.workstream.shared.model.WorkstreamFilterModel;
import de.justsoftware.onx.workstream.shared.model.WorkstreamMessageId;
import de.justsoftware.onx.workstream.shared.model.WorkstreamMessageType;
import de.justsoftware.onx.workstream.shared.model.attachments.Attachment;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.joda.time.DateTime;

@ParametersAreNonnullByDefault
public interface WorkstreamDataService {
    @Nonnull
    public WorkstreamMessageId saveEntry(DBWorkstreamMessage var1, ImmutableList<? extends Attachment> var2, @Nullable ItemId var3, @Nullable AttachmentProcessor var4);

    public void publish(Set<WorkstreamMessageId> var1, Date var2);

    @Nonnull
    public List<DBWorkstreamMessage> getWorkstream(ItemId var1, WorkstreamMessagePublishedStateFilter var2, @Nullable Boolean var3, @Nullable Date var4, @Nullable Date var5, @Nullable Integer var6, WorkstreamFilterModel var7, @Nullable PersonId var8, Set<String> var9, ImmutableSet<ItemId> var10);

    @Nonnull
    public ImmutableSet<WorkstreamMessageId> getMessagesByAttributes(Set<WorkstreamTypeAttributeValue> var1);

    @Nonnull
    @CheckReturnValue
    public DeleteTransactionCallback deleteEntriesByIds(Set<WorkstreamMessageId> var1);

    @CheckForNull
    public DBWorkstreamMessage getEntryByOriginAndType(ItemId var1, WorkstreamMessageType var2);

    public void updateModifiedAt(WorkstreamMessageId var1, Date var2);

    public void updatePinned(WorkstreamMessageId var1, boolean var2, PersonId var3, DateTime var4);

    public void updatePinnedHideDate(ItemId var1, PersonId var2, DateTime var3);

    @CheckForNull
    public DateTime getPinnedHideDate(ItemId var1, PersonId var2);

    public void deletePinnedHideDate(ItemId var1, PersonId var2);

    public void deletePinnedHideDatesByOrigins(Set<? extends ItemId> var1);

    public void deletePinnedHideDatesByPersons(Set<PersonId> var1);

    @Nonnull
    public ImmutableMap<WorkstreamMessageId, DBWorkstreamMessage> getEntries(Set<WorkstreamMessageId> var1);

    @Nonnull
    default public Optional<DBWorkstreamMessage> getEntry(WorkstreamMessageId id) {
        return Optional.ofNullable((DBWorkstreamMessage)this.getEntries((Set<WorkstreamMessageId>)ImmutableSet.of((Object)id)).get((Object)id));
    }

    @CheckForNull
    public DBWorkstreamMessage getMessageAttachedTo(ItemId var1);

    @Nonnull
    public ImmutableMap<ItemId, WorkstreamMessageId> getWorkstreamEntryIdsByAttachments(Set<? extends ItemId> var1);

    @Nonnull
    public ImmutableMap<ItemId, WorkstreamMessageId> getMicroblogEntryIdsByAttachments(Set<? extends ItemId> var1);

    @Nonnull
    public ImmutableSet<WorkstreamMessageId> getWorkstreamMessageIdsByOrigins(Set<? extends ItemId> var1);

    @Nonnull
    public ImmutableListMultimap<WorkstreamMessageId, ItemId> getAttachedItemIds(Set<WorkstreamMessageId> var1);

    @Nonnull
    public ImmutableMap<WorkstreamMessageId, Date> getNewMessagesSince(ItemId var1, @Nullable Date var2, WorkstreamFilterModel var3, @Nullable PersonId var4, Set<String> var5);

    @Nonnull
    public ImmutableSet<WorkstreamMessageId> getAllNewMessagesByOthersSince(ItemId var1, @Nullable Date var2, WorkstreamFilterModel var3, @Nullable PersonId var4, Set<String> var5);

    public void deleteAttachment(WorkstreamMessageId var1, ItemId var2);

    public void updateAttachments(WorkstreamMessageId var1, @Nullable ItemId var2, ImmutableSet<ItemId> var3, ImmutableList<? extends Attachment> var4, @Nullable AttachmentProcessorForEdits var5);

    @Nonnull
    public ImmutableMap<EntityId, DateTime> getNewestWorkstreamDateDirect(Set<EntityId> var1);

    @Nonnull
    public ImmutableMap<EntityId, DateTime> getNewestWorkstreamDateIndirect(Set<EntityId> var1);

    public void invalidateIndirectParents(Iterable<EntityId> var1);

    public void updateAttributes(WorkstreamMessageId var1, Map<String, String> var2);

    @Nonnull
    public ImmutableMap<WorkstreamMessageId, DBWorkstreamMessage> getMessagesForTypeAndSubject(Set<WorkstreamMessageType> var1, Set<? extends ItemId> var2);

    @Nonnull
    public ImmutableMap<WorkstreamMessageId, DBWorkstreamMessage> getMessagesForTypeSubjectAndAttribute(WorkstreamMessageType var1, ItemId var2, String var3, String var4);

    @ParametersAreNonnullByDefault
    public static interface AttachmentProcessorForEdits {
        @Nonnull
        public ImmutableList<? extends Attachment> processWithOriginId(ImmutableList<? extends Attachment> var1, @Nullable ItemId var2);
    }

    @ParametersAreNonnullByDefault
    public static interface AttachmentProcessor {
        @Nonnull
        public ImmutableList<? extends Attachment> processWithWorkstreamMessageId(ImmutableList<? extends Attachment> var1, WorkstreamMessageId var2);
    }
}

