/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.workstream.business;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContextWithLocale;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.model.action.Action;
import de.justsoftware.onx.person.shared.model.PersonTeaserModel;
import de.justsoftware.onx.workstream.business.impl.AbstractWorkstreamMessageHandler;
import de.justsoftware.onx.workstream.shared.model.DBWorkstreamMessage;
import de.justsoftware.onx.workstream.shared.model.WorkstreamMessageId;
import de.justsoftware.onx.workstream.shared.model.messages.WorkstreamMessage;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSingleWorkstreamMessageHandler<W extends WorkstreamMessage>
extends AbstractWorkstreamMessageHandler<W> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractSingleWorkstreamMessageHandler.class);

    @Override
    public ImmutableMap<WorkstreamMessageId, W> convert(Iterable<DBWorkstreamMessage> messages, Map<PersonId, PersonTeaserModel> personTeasers, ImmutableSetMultimap<Optional<WorkstreamMessageId>, Action> workstreamPermissions, AuthorizationCheckContextWithLocale authorizationContext) {
        ImmutableMap.Builder result = ImmutableMap.builder();
        for (DBWorkstreamMessage dbMsg : messages) {
            try {
                ImmutableSet may;
                W res;
                PersonId authorId = dbMsg.getAuthorId().asPersonId();
                PersonTeaserModel authorTeaser = personTeasers.get(authorId);
                if (authorTeaser == null || (res = this.convert(dbMsg, authorTeaser, (ImmutableSet<Action>)(may = workstreamPermissions.get((Object)Optional.of((Object)dbMsg.getId()))), authorizationContext)) == null) continue;
                result.put((Object)((WorkstreamMessageId)res.getId()), res);
            }
            catch (RuntimeException e) {
                LOG.error("Error creating WorkstreamMessage from " + dbMsg.toString(), (Throwable)e);
            }
        }
        return result.build();
    }

    @CheckForNull
    protected abstract W convert(@Nonnull DBWorkstreamMessage var1, @Nonnull PersonTeaserModel var2, @Nonnull ImmutableSet<Action> var3, @Nonnull AuthorizationCheckContextWithLocale var4);
}

