/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.wikieditor.shared.server.model;

import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import de.justsoftware.onx.common.shared.model.component.ComponentType;
import de.justsoftware.onx.common.shared.model.component.StaticComponentType;
import de.justsoftware.onx.container.shared.model.GlobalId;
import de.justsoftware.onx.container.shared.server.model.Item;
import de.justsoftware.onx.container.shared.server.model.ItemVisitor;
import de.justsoftware.onx.wikieditor.shared.model.DBWikiEditor;
import de.justsoftware.onx.wikieditor.shared.model.WikiEditorId;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class WikiEditorItem
implements Item<WikiEditorId> {
    public static final Function<DBWikiEditor, WikiEditorItem> FROM_DBEDITOR = new Function<DBWikiEditor, WikiEditorItem>(){

        public WikiEditorItem apply(DBWikiEditor input) {
            return WikiEditorItem.of(input);
        }
    };
    private final DBWikiEditor _editor;

    public WikiEditorItem(@Nonnull DBWikiEditor editor) {
        this._editor = editor;
    }

    @CheckForNull
    public static WikiEditorItem of(@Nullable DBWikiEditor wikiEditor) {
        return wikiEditor != null ? new WikiEditorItem(wikiEditor) : null;
    }

    @Nonnull
    public DBWikiEditor getEditor() {
        return this._editor;
    }

    @Override
    public WikiEditorId getId() {
        return this._editor.getId();
    }

    @Override
    public GlobalId getParentId() {
        return this._editor.getParentId();
    }

    @Override
    public ComponentType getModuleType() {
        return StaticComponentType.WIKI_EDITOR;
    }

    @Override
    public <T> T accept(ItemVisitor<T> v) {
        return v.visit(this);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("editor", (Object)this._editor).toString();
    }
}

