/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.wikieditor.shared.server.model;

import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import de.justsoftware.onx.common.shared.model.component.ComponentType;
import de.justsoftware.onx.common.shared.model.component.StaticComponentType;
import de.justsoftware.onx.container.shared.server.model.Item;
import de.justsoftware.onx.container.shared.server.model.ItemVisitor;
import de.justsoftware.onx.wikieditor.shared.model.DBWikiBackup;
import de.justsoftware.onx.wikieditor.shared.model.WikiBackupId;
import de.justsoftware.onx.wikieditor.shared.model.WikiEditorId;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class WikiBackupItem
implements Item<WikiBackupId> {
    public static final Function<DBWikiBackup, WikiBackupItem> FROM_DBBACKUP = new Function<DBWikiBackup, WikiBackupItem>(){

        public WikiBackupItem apply(DBWikiBackup input) {
            return WikiBackupItem.of(input);
        }
    };
    private final DBWikiBackup _backup;

    public WikiBackupItem(@Nonnull DBWikiBackup backup) {
        this._backup = backup;
    }

    @CheckForNull
    public static WikiBackupItem of(@Nullable DBWikiBackup wikiBackup) {
        return wikiBackup != null ? new WikiBackupItem(wikiBackup) : null;
    }

    @Nonnull
    public DBWikiBackup getBackup() {
        return this._backup;
    }

    @Override
    public WikiBackupId getId() {
        return this._backup.getId();
    }

    @Override
    public WikiEditorId getParentId() {
        return this._backup.getWikiEditorId();
    }

    @Override
    public ComponentType getModuleType() {
        return StaticComponentType.WIKI_EDITOR;
    }

    @Override
    public <T> T accept(ItemVisitor<T> v) {
        return v.visit(this);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("backup", (Object)this._backup).toString();
    }
}

