/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.wikieditor.shared.model;

import com.google.common.base.MoreObjects;
import de.justsoftware.onx.common.shared.util.Dates;
import de.justsoftware.onx.person.shared.model.PersonTeaserModel;
import de.justsoftware.onx.wikieditor.shared.model.WikiVersionId;
import de.justsoftware.onx.wikieditor.shared.model.WikiVersionTeaser;
import java.util.Date;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

public class WikiVersion
implements WikiVersionTeaser {
    private static final long serialVersionUID = 5116191870210659542L;
    private PersonTeaserModel _author;
    private String _text;
    private Date _createDate;
    private WikiVersionId _id;
    private int _version;

    @Deprecated
    public WikiVersion() {
    }

    @ParametersAreNonnullByDefault
    public WikiVersion(WikiVersionId id, int version, String text, @Nullable PersonTeaserModel author, Date createDate) {
        this._id = id;
        this._version = version;
        this._text = text;
        this._author = author;
        this._createDate = Dates.clone(createDate);
    }

    @CheckForNull
    public PersonTeaserModel getAuthor() {
        return this._author;
    }

    @Nonnull
    public String getText() {
        return this._text;
    }

    @Nonnull
    public Date getCreateDate() {
        return Dates.clone(this._createDate);
    }

    @Override
    public WikiVersionId getId() {
        return this._id;
    }

    @Override
    public int getVersion() {
        return this._version;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this._id).add("version", this._version).add("text", (Object)this._text).add("author", (Object)this._author).add("createDate", (Object)this._createDate).toString();
    }
}

