/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.wikieditor.business.impl;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContextWithLocale;
import de.justsoftware.onx.common.shared.model.action.Action;
import de.justsoftware.onx.container.business.EntityService;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.container.shared.model.db.DBEntity;
import de.justsoftware.onx.person.shared.model.PersonTeaserModel;
import de.justsoftware.onx.wikieditor.business.WikiNewVersionStreamHandler;
import de.justsoftware.onx.workstream.business.AbstractSingleWorkstreamMessageHandler;
import de.justsoftware.onx.workstream.shared.model.DBWorkstreamMessage;
import de.justsoftware.onx.workstream.shared.model.messages.WikiVersionCreated;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="wikiNewVersionStreamHandler")
public class WikiNewVersionStreamHandlerImpl
extends AbstractSingleWorkstreamMessageHandler<WikiVersionCreated>
implements WikiNewVersionStreamHandler {
    @Autowired
    private EntityService _entityService;

    @Override
    public ImmutableSetMultimap<String, String> attributesToDelete(Set<? extends ItemId> itemIds) {
        return ImmutableSetMultimap.of();
    }

    @Override
    public WikiVersionCreated aggregate(WikiVersionCreated oldEntry, WikiVersionCreated newEntry) {
        return newEntry;
    }

    @Override
    public boolean isAggregatePossible() {
        return true;
    }

    @Override
    public WikiVersionCreated convert(DBWorkstreamMessage m, PersonTeaserModel author, ImmutableSet<Action> may, AuthorizationCheckContextWithLocale authorizationContext) {
        String versionAttribute = m.getAttribute("version");
        if (versionAttribute == null) {
            return null;
        }
        DBEntity entity = this._entityService.getById((EntityId)m.getOriginItemId());
        if (entity == null) {
            return null;
        }
        return new WikiVersionCreated(m, author, may, entity.getType(), entity.getName(), Integer.parseInt(versionAttribute));
    }
}

