/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.wikieditor.business.impl;

import com.freiheit.toro.cache.CacheKey;
import com.freiheit.toro.cache.CacheName;
import com.freiheit.toro.cache.memcached.MemcachedClientCache;
import com.freiheit.toro.common.shared.model.PermissionDeniedException;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContext;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContextWithLocale;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContextWithUserId;
import de.justsoftware.onx.authorization.business.SearchAuthorizationCheckContext;
import de.justsoftware.onx.common.business.CacheHelper;
import de.justsoftware.onx.common.business.CacheMissHandler;
import de.justsoftware.onx.common.business.I18nService;
import de.justsoftware.onx.common.business.InvalidIDException;
import de.justsoftware.onx.common.business.events.JCEventBus;
import de.justsoftware.onx.common.business.events.util.ServerEventCollector;
import de.justsoftware.onx.common.cache.AbstractListLoadingCacheAccessor;
import de.justsoftware.onx.common.cache.AbstractListMultiMapCacheAccessor;
import de.justsoftware.onx.common.cache.AbstractMapLoadingCacheAccessor;
import de.justsoftware.onx.common.deletion.DeleteTransactionCallback;
import de.justsoftware.onx.common.deletion.DeletionContext;
import de.justsoftware.onx.common.deletion.DeletionService;
import de.justsoftware.onx.common.deletion.TransactionCallbackWithDeleteAction;
import de.justsoftware.onx.common.deletion.model.DeleteAction;
import de.justsoftware.onx.common.shared.model.ListAndCount;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.model.ProfileId;
import de.justsoftware.onx.common.shared.model.action.Action;
import de.justsoftware.onx.common.shared.model.action.StaticAction;
import de.justsoftware.onx.common.shared.model.component.ComponentType;
import de.justsoftware.onx.common.shared.server.util.BeanUtil;
import de.justsoftware.onx.container.business.EntityAdministrationWorkflowService;
import de.justsoftware.onx.container.business.EntityService;
import de.justsoftware.onx.container.business.ItemService;
import de.justsoftware.onx.container.shared.i18n.EntityConstants;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityMember;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.container.shared.model.GlobalId;
import de.justsoftware.onx.container.shared.model.Identifiables;
import de.justsoftware.onx.container.shared.model.ModuleData;
import de.justsoftware.onx.container.shared.model.db.DBEntity;
import de.justsoftware.onx.container.shared.server.model.EntityItem;
import de.justsoftware.onx.container.shared.server.model.Item;
import de.justsoftware.onx.events.EntityUpdateEvent;
import de.justsoftware.onx.events.business.UpdateEventHandler;
import de.justsoftware.onx.person.business.PersonService;
import de.justsoftware.onx.person.model.DBPerson;
import de.justsoftware.onx.person.shared.model.PersonTeaserModel;
import de.justsoftware.onx.person.shared.server.model.ProfileItem;
import de.justsoftware.onx.profile.business.ProfileTeaserService;
import de.justsoftware.onx.util.shared.NullPermeableFunction;
import de.justsoftware.onx.wikieditor.business.WikiEditorService;
import de.justsoftware.onx.wikieditor.business.events.NewWikiVersionEvent;
import de.justsoftware.onx.wikieditor.integration.persistence.WikiEditorDAO;
import de.justsoftware.onx.wikieditor.shared.model.DBWikiBackup;
import de.justsoftware.onx.wikieditor.shared.model.DBWikiEditor;
import de.justsoftware.onx.wikieditor.shared.model.WikiBackupId;
import de.justsoftware.onx.wikieditor.shared.model.WikiBackupTeaser;
import de.justsoftware.onx.wikieditor.shared.model.WikiEditor;
import de.justsoftware.onx.wikieditor.shared.model.WikiEditorId;
import de.justsoftware.onx.wikieditor.shared.model.WikiPreEditResult;
import de.justsoftware.onx.wikieditor.shared.model.WikiVersion;
import de.justsoftware.onx.wikieditor.shared.model.WikiVersionBadge;
import de.justsoftware.onx.wikieditor.shared.model.WikiVersionBadgeBean;
import de.justsoftware.onx.wikieditor.shared.model.WikiVersionId;
import de.justsoftware.onx.wikieditor.shared.model.WikiVersionTeaser;
import de.justsoftware.onx.wikieditor.shared.model.WikiVersionTeaserBean;
import de.justsoftware.onx.wikieditor.shared.server.model.AbstractDBWikiVersion;
import de.justsoftware.onx.wikieditor.shared.server.model.DBWikiVersion;
import de.justsoftware.onx.wikieditor.shared.server.model.DBWikiVersionBadge;
import de.justsoftware.onx.wikieditor.shared.server.model.WikiBackupItem;
import de.justsoftware.onx.wikieditor.shared.server.model.WikiEditorItem;
import de.justsoftware.onx.wikieditor.shared.server.model.WikiVersionItem;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.TransactionStatus;

@Service
public class WikiEditorServiceImpl
implements WikiEditorService {
    private static final ImmutableSet<? extends Action> WIKI_VERSION_CHECK_ACTIONS = ImmutableSet.of((Object)StaticAction.WIKI_DELETE);
    private static final ImmutableSet<? extends Action> WIKI_EDITOR_CHECK_ACTIONS = ImmutableSet.of((Object)StaticAction.WIKI_SAVE, (Object)StaticAction.WIKI_READ_VERSIONS);
    private final WikiEditorDAO _wikiEditorDAO;
    private final MemcachedClientCache _cache;
    @Autowired
    private CacheHelper _cacheHelper;
    @Autowired
    private ItemService _itemService;
    @Autowired
    private PersonService _personService;
    @Autowired
    private ProfileTeaserService _profileTeaserService;
    @Autowired
    private EntityService _entityService;
    @Autowired
    private EntityAdministrationWorkflowService _entityAdministrationService;
    @Autowired
    private I18nService _i18nService;
    @Autowired
    private UpdateEventHandler _updateHandler;
    @Autowired
    private JCEventBus _eventBus;
    @Autowired
    private DeletionService _deletionService;
    private final WikiEditorByParentCacheAccessor _wikiEditorByParentCacheAccessor;
    private final CurrentWikiVersionByEditorCacheAccessor _currentWikiVersionByEditorCacheAccessor;
    private final WikiVersionBadgeCacheAccessor _wikiVersionBadgeCacheAccessor;
    private final WikiVersionByIdCacheAccessor _wikiVersionByIdCacheAccessor;

    @Autowired
    @ParametersAreNonnullByDefault
    public WikiEditorServiceImpl(MemcachedClientCache cache, WikiEditorDAO wikiEditorDAO) {
        this._cache = cache;
        this._wikiEditorDAO = wikiEditorDAO;
        this._wikiEditorByParentCacheAccessor = new WikiEditorByParentCacheAccessor(cache, wikiEditorDAO);
        this._currentWikiVersionByEditorCacheAccessor = new CurrentWikiVersionByEditorCacheAccessor(cache, wikiEditorDAO);
        this._wikiVersionBadgeCacheAccessor = new WikiVersionBadgeCacheAccessor(cache, wikiEditorDAO);
        this._wikiVersionByIdCacheAccessor = new WikiVersionByIdCacheAccessor(cache, wikiEditorDAO);
    }

    @Nonnull
    private static CacheKey wikiEditorCacheKey(@Nonnull WikiEditorId id) {
        return new CacheKey((CacheName)WikiEditorServiceCacheName.WIKI_EDITOR_ID, id);
    }

    @Nonnull
    private static CacheKey wikiBackupCacheKey(@Nonnull WikiBackupId id) {
        return new CacheKey((CacheName)WikiEditorServiceCacheName.WIKI_EDITOR_BACKUP, id);
    }

    @CheckForNull
    private static WikiVersionTeaser dbToWikiVersionTeaser(@Nullable DBWikiVersion dbWikiVersion) {
        if (dbWikiVersion == null) {
            return null;
        }
        return new WikiVersionTeaserBean(dbWikiVersion.getId(), dbWikiVersion.getVersion());
    }

    @Override
    public WikiVersionId insertWikiVersion(DBWikiVersion wikiVersion, Integer restoredFromVersion, boolean generateFeedMessage, boolean deleteBackup) throws InvalidIDException {
        WikiEditorId parentId = wikiVersion.getWikiEditorId();
        PersonId authorId = wikiVersion.getAuthorId();
        DBEntity parentEntity = InvalidIDException.check(parentId, this._itemService.getParentEntity(parentId));
        EntityId parentEntityId = parentEntity.getId();
        WikiVersionId versionId = this._wikiEditorDAO.insertWikiVersion(wikiVersion, restoredFromVersion);
        wikiVersion.setId(versionId);
        this._wikiVersionBadgeCacheAccessor.invalidateKey(parentId);
        this._currentWikiVersionByEditorCacheAccessor.invalidateKey(parentId);
        if (deleteBackup) {
            this.deleteWikiBackup(wikiVersion.getWikiEditorId().toWikiBackupId());
        }
        this._eventBus.post(new NewWikiVersionEvent(parentEntityId, wikiVersion.getVersion(), authorId, generateFeedMessage));
        this.notifyWikiEditorUpdateEvent(parentEntityId);
        return versionId;
    }

    private void notifyWikiEditorUpdateEvent(EntityId parentEntityId) {
        DBEntity dbEntity = this._entityService.getById(parentEntityId);
        if (dbEntity == null) {
            return;
        }
        this._updateHandler.onChange(new EntityUpdateEvent(dbEntity.getId()));
    }

    @Override
    public void create(ProfileItem parentProfileItem, ComponentType componentType, @Nullable ServerEventCollector eventCollector) {
        this.create(parentProfileItem.getId(), null, parentProfileItem.getId().asPersonId());
    }

    @Override
    public void create(ComponentType componentType, Iterable<DBEntity> entities, @Nullable ServerEventCollector eventCollector) {
        for (DBEntity parentEntity : entities) {
            EntityMember admin = this._entityAdministrationService.getAdmin(parentEntity.getId());
            PersonId adminPersonId = admin != null ? admin.getPersonId() : null;
            this.create(parentEntity.getId(), parentEntity.getType(), adminPersonId);
        }
    }

    private void create(@Nonnull GlobalId parentId, @Nullable EntityType entityType, @Nullable PersonId adminPersonId) {
        DBPerson person;
        DBPerson dBPerson = person = adminPersonId != null ? this._personService.getPersonById(adminPersonId) : null;
        if (person == null) {
            throw new IllegalStateException("Could not find admin for entity with id " + parentId.toString());
        }
        WikiEditorId editorId = this._wikiEditorDAO.createWikiEditor(parentId);
        EntityConstants entityConstants = this._i18nService.getEntityConstantsByEntityType(entityType, person.getLanguageId());
        DBWikiVersion wikiVersion = new DBWikiVersion(editorId, entityConstants.defaultWikiEditorText(), person.getId());
        this._wikiEditorDAO.insertWikiVersion(wikiVersion, null);
    }

    @Override
    public ImmutableMap<GlobalId, DBWikiEditor> getDBWikiEditorByParentIds(Set<? extends GlobalId> parentIds) {
        return this._wikiEditorByParentCacheAccessor.getMap(parentIds);
    }

    @Override
    public DBWikiEditor getDBWikiEditorByParentId(GlobalId parentId) {
        return (DBWikiEditor)this._wikiEditorByParentCacheAccessor.getSingle(parentId);
    }

    @Override
    public WikiVersion dbToWikiVersion(DBWikiVersion dbWikiVersion, AuthorizationCheckContextWithLocale auth) {
        String newHtml = dbWikiVersion.getText();
        return new WikiVersion(dbWikiVersion.getId(), dbWikiVersion.getVersion(), newHtml, this._profileTeaserService.getPersonTeaserById(dbWikiVersion.getAuthorId(), auth), dbWikiVersion.getCreateDate());
    }

    @Override
    public ModuleData getModuleData(SearchAuthorizationCheckContext authorizationContext, EntityItem entity, ComponentType componentType) throws InvalidIDException {
        EntityId entityId = entity.getId();
        DBWikiEditor dbWikiEditor = this.getDBWikiEditorByParentId(entityId);
        if (dbWikiEditor == null) {
            this.create(componentType, (Iterable<DBEntity>)ImmutableList.of((Object)entity.getEntity()), null);
            dbWikiEditor = InvalidIDException.check(entityId, this.getDBWikiEditorByParentId(entityId));
        }
        return this.getModuleData(dbWikiEditor, authorizationContext);
    }

    @Override
    public ModuleData getModuleData(SearchAuthorizationCheckContext authorizationContext, ProfileItem person, ComponentType componentType) throws InvalidIDException {
        ProfileId profileId = person.getId();
        DBWikiEditor dbWikiEditor = this.getDBWikiEditorByParentId(profileId);
        if (dbWikiEditor == null) {
            this.create(person, componentType, null);
            dbWikiEditor = InvalidIDException.check(profileId, this.getDBWikiEditorByParentId(profileId));
        }
        return this.getModuleData(dbWikiEditor, authorizationContext);
    }

    @Nonnull
    private ModuleData getModuleData(@Nonnull DBWikiEditor dbWikiEditor, @Nonnull SearchAuthorizationCheckContext authorizationContext) {
        WikiVersion wikiVersion = this.dbToWikiVersion(this.getCurrentDBWikiVersion(dbWikiEditor.getId()), authorizationContext);
        WikiEditor wikiEditor = BeanUtil.createBeanFromChildBean(WikiEditor.class, dbWikiEditor);
        wikiEditor.setCurrentVersion(wikiVersion);
        DBWikiBackup wikiBackup = this.getDBWikiBackupById(dbWikiEditor.getId().toWikiBackupId());
        if (wikiBackup != null && authorizationContext.may((Item<?>)new WikiBackupItem(wikiBackup), (Action)StaticAction.WIKI_READ_BACKUP_TEASER)) {
            wikiEditor.setBackup(new WikiBackupTeaser(this._profileTeaserService.getPersonTeaserById(wikiBackup.getAuthorId(), authorizationContext), wikiBackup.getCreateDate()));
        }
        wikiEditor.setMay(authorizationContext.may(new WikiEditorItem(dbWikiEditor), WIKI_EDITOR_CHECK_ACTIONS));
        return wikiEditor;
    }

    @Override
    public DBWikiBackup getDBWikiBackupById(final WikiBackupId id) {
        return this._cacheHelper.getFromCache(WikiEditorServiceImpl.wikiBackupCacheKey(id), new CacheMissHandler<DBWikiBackup>(){

            @Override
            public DBWikiBackup handleCacheMiss() {
                return WikiEditorServiceImpl.this._wikiEditorDAO.getWikiBackupById(id);
            }
        });
    }

    @Override
    public Map<WikiBackupId, DBWikiBackup> getDBWikiBackupsByIds(Iterable<WikiBackupId> ids) {
        HashMap result = Maps.newHashMap();
        for (WikiBackupId wikiEditorId : ids) {
            DBWikiBackup backup = this.getDBWikiBackupById(wikiEditorId);
            result.put(backup.getId(), backup);
        }
        return result;
    }

    @Override
    public DBWikiEditor getDBWikiEditorById(final WikiEditorId id) {
        return this._cacheHelper.getFromCache(WikiEditorServiceImpl.wikiEditorCacheKey(id), new CacheMissHandler<DBWikiEditor>(){

            @Override
            public DBWikiEditor handleCacheMiss() {
                return WikiEditorServiceImpl.this._wikiEditorDAO.getWikiEditorById(id);
            }
        });
    }

    @Override
    public Map<WikiEditorId, DBWikiEditor> getDBWikiEditorsByIds(Iterable<WikiEditorId> ids) {
        HashMap<WikiEditorId, DBWikiEditor> result = new HashMap<WikiEditorId, DBWikiEditor>();
        for (WikiEditorId wikiEditorId : ids) {
            DBWikiEditor editor = this.getDBWikiEditorById(wikiEditorId);
            if (editor == null) continue;
            result.put(editor.getId(), editor);
        }
        return result;
    }

    @Override
    public DBWikiVersion getDBWikiVersionById(WikiVersionId id) {
        return (DBWikiVersion)this._wikiVersionByIdCacheAccessor.getSingle(id);
    }

    @Override
    public Map<WikiVersionId, DBWikiVersion> getDBWikiVersionsById(Set<WikiVersionId> ids) {
        return this._wikiVersionByIdCacheAccessor.getMap(ids);
    }

    @Override
    public DBWikiVersion getCurrentDBWikiVersion(WikiEditorId id) {
        return (DBWikiVersion)this._currentWikiVersionByEditorCacheAccessor.getSingle(id);
    }

    @Override
    public ImmutableMap<WikiEditorId, DBWikiVersion> getCurrentWikiVersions(Set<WikiEditorId> wikiEditorIds) {
        return this._currentWikiVersionByEditorCacheAccessor.getMap(wikiEditorIds);
    }

    @Override
    public void deleteWikiVersion(WikiVersionId wikiVersionId, AuthorizationCheckContextWithUserId authorizationContext) {
        final DBWikiVersion wikiVersion = this.getDBWikiVersionById(wikiVersionId);
        if (wikiVersion == null) {
            return;
        }
        authorizationContext.check(new WikiVersionItem(wikiVersion), (Action)StaticAction.WIKI_DELETE);
        WikiEditorId wikiEditorId = wikiVersion.getWikiEditorId();
        DBWikiVersion lastVersion = this.getCurrentDBWikiVersion(wikiEditorId);
        if (lastVersion.getId().equals(wikiVersionId)) {
            throw new PermissionDeniedException("You are not allowed to delete the current wiki version");
        }
        this._deletionService.deleteInTransactionWithDeleteAction(wikiVersionId, authorizationContext.getUserId(), new TransactionCallbackWithDeleteAction<Object>(){

            @Override
            public Object doInTransactionWithDeleteAction(TransactionStatus status, DeleteAction deleteAction) {
                WikiEditorServiceImpl.this._wikiEditorDAO.deleteWikiVersion(wikiVersion.getId());
                return this;
            }
        });
        this._currentWikiVersionByEditorCacheAccessor.invalidateKey(wikiEditorId);
        this._wikiVersionBadgeCacheAccessor.invalidateKey(wikiEditorId);
        this._wikiVersionByIdCacheAccessor.invalidateKey(wikiVersionId);
    }

    @Override
    public void saveWikiBackup(DBWikiBackup dbWikiBackup) {
        this._wikiEditorDAO.saveWikiBackup(dbWikiBackup);
        this._cache.delete(WikiEditorServiceImpl.wikiBackupCacheKey(dbWikiBackup.getId()));
    }

    @Override
    public void deleteWikiBackup(WikiBackupId id) {
        this._wikiEditorDAO.deleteWikiBackup(id);
        this._cache.delete(WikiEditorServiceImpl.wikiBackupCacheKey(id));
    }

    @Override
    public ListAndCount<WikiVersionBadge> getWikiVersionBadges(WikiEditorId id, int offset, int limit, AuthorizationCheckContextWithLocale authorizationContext) {
        ImmutableList all = (ImmutableList)this._wikiVersionBadgeCacheAccessor.getSingle(id);
        final ImmutableMap allVersionsMapped = Maps.uniqueIndex((Iterable)all, DBWikiVersionBadge.GET_VERSION);
        ListAndCount data = new ListAndCount(all, offset, limit);
        ImmutableSet authorIds = FluentIterable.from(data).transform(AbstractDBWikiVersion.GET_AUTHOR_ID).toSet();
        final ImmutableMap<PersonId, PersonTeaserModel> authors = this._profileTeaserService.getPersonTeasersByIds((Set<PersonId>)authorIds, authorizationContext);
        final ImmutableSetMultimap may = authorizationContext.may(FluentIterable.from(data).transform(WikiVersionItem.FROM_DBEDITOR), WIKI_VERSION_CHECK_ACTIONS);
        return ListAndCount.transform(data, new NullPermeableFunction<DBWikiVersionBadge, WikiVersionBadge>(){

            @Override
            protected WikiVersionBadge applySafe(DBWikiVersionBadge input) {
                DBWikiVersionBadge restored = (DBWikiVersionBadge)allVersionsMapped.get((Object)input.getRestoredVersion());
                return new WikiVersionBadgeBean(input.getId(), input.getVersion(), (PersonTeaserModel)authors.get((Object)input.getAuthorId()), input.getRestoredVersion(), restored != null ? restored.getId() : null, input.getCreateDate(), (ImmutableSet<Action>)may.get((Object)Optional.of((Object)input.getId())));
            }
        });
    }

    @Override
    public WikiEditor getWikiEditorById(DBWikiEditor dbWikiEditor, AuthorizationCheckContextWithLocale authorizationContext) {
        WikiVersion wikiVersion = this.dbToWikiVersion(this.getCurrentDBWikiVersion(dbWikiEditor.getId()), authorizationContext);
        WikiEditor wikiEditor = BeanUtil.createBeanFromChildBean(WikiEditor.class, dbWikiEditor);
        wikiEditor.setCurrentVersion(wikiVersion);
        DBWikiBackup wikiBackup = this.getDBWikiBackupById(dbWikiEditor.getId().toWikiBackupId());
        wikiEditor.setBackup(wikiBackup == null ? null : new WikiBackupTeaser(this._profileTeaserService.getPersonTeaserById(wikiBackup.getAuthorId(), authorizationContext), wikiBackup.getCreateDate()));
        wikiEditor.setMay(authorizationContext.may(new WikiEditorItem(dbWikiEditor), WIKI_EDITOR_CHECK_ACTIONS));
        return wikiEditor;
    }

    @Override
    public ImmutableMap<EntityId, String> getTeaserTexts(Map<EntityId, DBEntity> entities, AuthorizationCheckContext authCtx) {
        ImmutableMap<GlobalId, DBWikiEditor> wikiEditors = this.getDBWikiEditorByParentIds(entities.keySet());
        ImmutableSet wikiEditorIds = ImmutableSet.copyOf((Iterable)Iterables.transform((Iterable)wikiEditors.values(), Identifiables.toId()));
        ImmutableMap<WikiEditorId, DBWikiVersion> wikiVersions = this.getCurrentWikiVersions((Set<WikiEditorId>)wikiEditorIds);
        Iterable wikiVersionIds = Iterables.transform((Iterable)wikiVersions.values(), Identifiables.toId());
        ImmutableSet may = authCtx.filterAllowedIds(wikiVersionIds, StaticAction.WIKI_READ);
        ImmutableMap.Builder result = ImmutableMap.builder();
        for (EntityId entityId : entities.keySet()) {
            DBWikiVersion wikiVersion;
            DBWikiEditor wikiEditor = (DBWikiEditor)wikiEditors.get((Object)entityId);
            if (wikiEditor == null || (wikiVersion = (DBWikiVersion)wikiVersions.get((Object)wikiEditor.getId())) == null || !may.contains((Object)wikiVersion.getId())) continue;
            result.put((Object)entityId, (Object)wikiVersion.getText());
        }
        return result.build();
    }

    @Override
    public ImmutableSetMultimap<WikiEditorId, WikiVersionId> getWikiVersionIdsByWikiEditorIds(Set<WikiEditorId> wikiEditorIds) {
        return this._wikiEditorDAO.getAllWikiVersionIdsByWikiEditorIds(wikiEditorIds);
    }

    @Override
    public void deleteDependentWikiEditor(final WikiEditorId wikiEditorId, final GlobalId parentId, DeletionContext deletionContext) {
        this._wikiEditorDAO.deleteWikiEditor(wikiEditorId);
        deletionContext.attach(new DeleteTransactionCallback(){

            @Override
            public void afterCommit() {
                WikiEditorServiceImpl.this._cache.delete(WikiEditorServiceImpl.wikiEditorCacheKey(wikiEditorId));
                WikiEditorServiceImpl.this._wikiEditorByParentCacheAccessor.invalidateKey(parentId);
                WikiEditorServiceImpl.this._cache.delete(WikiEditorServiceImpl.wikiBackupCacheKey(wikiEditorId.toWikiBackupId()));
            }
        });
    }

    @Override
    public void deleteDependentWikiVersions(final Iterable<WikiVersionId> wikiVersionIds, final Iterable<WikiEditorId> wikiEditorIds, DeletionContext deletionContext) {
        this._wikiEditorDAO.deleteWikiVersions(wikiVersionIds);
        deletionContext.attach(new DeleteTransactionCallback(){

            @Override
            public void afterCommit() {
                WikiEditorServiceImpl.this._currentWikiVersionByEditorCacheAccessor.invalidateKeys(wikiEditorIds);
                WikiEditorServiceImpl.this._wikiVersionBadgeCacheAccessor.invalidateKeys(wikiEditorIds);
                WikiEditorServiceImpl.this._wikiVersionByIdCacheAccessor.invalidateKeys(wikiVersionIds);
            }
        });
    }

    @Override
    public ImmutableSet<WikiEditorId> getWikiBackupsForPersons(Set<PersonId> authorIds) {
        return this._wikiEditorDAO.getWikiEditorIdWithBackupFromPersons(authorIds);
    }

    @Override
    public void deleteDependentWikiBackups(Set<WikiEditorId> wikiEditorIds, DeletionContext deletionContext) {
        this._wikiEditorDAO.deleteWikiEditorBackups(wikiEditorIds);
        final ImmutableSet cacheKeys = ImmutableSet.copyOf((Iterable)Iterables.filter((Iterable)Iterables.transform(wikiEditorIds, (Function)new Function<WikiEditorId, CacheKey>(){

            public CacheKey apply(WikiEditorId input) {
                return input != null ? WikiEditorServiceImpl.wikiBackupCacheKey(input.toWikiBackupId()) : null;
            }
        }), (Predicate)Predicates.notNull()));
        deletionContext.attach(new DeleteTransactionCallback(){

            @Override
            public void afterCommit() {
                WikiEditorServiceImpl.this._cacheHelper.delete((ImmutableSet<CacheKey>)cacheKeys);
            }
        });
    }

    @Override
    public WikiPreEditResult preEditCheck(WikiEditorId id, WikiVersionId versionId, AuthorizationCheckContextWithLocale auth) throws InvalidIDException {
        DBWikiBackup backup = this.getDBWikiBackupById(id.toWikiBackupId());
        DBWikiVersion currentVersion = this.getCurrentDBWikiVersion(id);
        return new WikiPreEditResult(backup != null, versionId.equals(currentVersion.getId()) ? null : this.dbToWikiVersion(currentVersion, auth));
    }

    @Override
    public ImmutableMap<GlobalId, DBWikiVersion> getCurrentDBWikiVersionByParentId(Set<? extends GlobalId> entityId) {
        ImmutableMap<GlobalId, DBWikiEditor> wikiEditors = this.getDBWikiEditorByParentIds(entityId);
        ImmutableSet wikis = FluentIterable.from((Iterable)wikiEditors.values()).transform(Identifiables.toId()).toSet();
        final ImmutableMap<WikiEditorId, DBWikiVersion> versions = this.getCurrentWikiVersions((Set<WikiEditorId>)wikis);
        Map transformed = Maps.transformValues(wikiEditors, (Function)new NullPermeableFunction<DBWikiEditor, DBWikiVersion>(){

            @Override
            protected DBWikiVersion applySafe(DBWikiEditor input) {
                return (DBWikiVersion)versions.get((Object)input.getId());
            }
        });
        Map nonnull = Maps.filterValues((Map)transformed, (Predicate)Predicates.notNull());
        return ImmutableMap.copyOf((Map)nonnull);
    }

    private static final class CurrentWikiVersionByEditorCacheAccessor
    extends AbstractMapLoadingCacheAccessor<WikiEditorServiceCacheName, WikiEditorId, DBWikiVersion> {
        private final WikiEditorDAO _wikiEditorDAO;

        private CurrentWikiVersionByEditorCacheAccessor(@Nonnull MemcachedClientCache cache, @Nonnull WikiEditorDAO wikiEditorDAO) {
            super(cache, WikiEditorServiceCacheName.WIKI_EDITOR_CURRENT);
            this._wikiEditorDAO = wikiEditorDAO;
        }

        @Override
        protected String keyToString(WikiEditorId key) {
            return key.asString();
        }

        @Override
        protected Map<WikiEditorId, DBWikiVersion> getFromDatabaseMulti(Set<? extends WikiEditorId> inputs) {
            return this._wikiEditorDAO.getCurrentWikiVersions(inputs);
        }
    }

    private static final class WikiEditorByParentCacheAccessor
    extends AbstractListLoadingCacheAccessor<WikiEditorServiceCacheName, GlobalId, DBWikiEditor> {
        private final WikiEditorDAO _wikiEditorDAO;

        protected WikiEditorByParentCacheAccessor(MemcachedClientCache cache, WikiEditorDAO wikiEditorDAO) {
            super(cache, WikiEditorServiceCacheName.WIKI_EDITOR_PARENT);
            this._wikiEditorDAO = wikiEditorDAO;
        }

        @Override
        protected GlobalId objectToKey(DBWikiEditor dbResult) {
            return dbResult.getParentId();
        }

        @Override
        protected Iterable<? extends DBWikiEditor> getListFromDatabase(Set<? extends GlobalId> inputs) {
            return this._wikiEditorDAO.getWikiEditorsByParentIds(inputs);
        }

        @Override
        protected String keyToString(GlobalId key) {
            return key.asString();
        }
    }

    private static class WikiVersionByIdCacheAccessor
    extends AbstractListLoadingCacheAccessor<WikiEditorServiceCacheName, WikiVersionId, DBWikiVersion> {
        private final WikiEditorDAO _wikiEditorDAO;

        @ParametersAreNonnullByDefault
        WikiVersionByIdCacheAccessor(MemcachedClientCache cache, WikiEditorDAO wikiEditorDAO) {
            super(cache, WikiEditorServiceCacheName.WIKI_EDITOR_VERSION_BY_ID);
            this._wikiEditorDAO = wikiEditorDAO;
        }

        @Override
        protected WikiVersionId objectToKey(DBWikiVersion dbResult) {
            return dbResult.getId();
        }

        @Override
        protected Iterable<DBWikiVersion> getListFromDatabase(Set<? extends WikiVersionId> inputs) {
            return this._wikiEditorDAO.getWikiVersionsByIds(inputs).values();
        }

        @Override
        protected String keyToString(WikiVersionId key) {
            return Long.toString(key.getId());
        }
    }

    private static class WikiVersionBadgeCacheAccessor
    extends AbstractListMultiMapCacheAccessor<WikiEditorServiceCacheName, WikiEditorId, DBWikiVersionBadge> {
        private final WikiEditorDAO _wikiEditorDAO;

        @ParametersAreNonnullByDefault
        WikiVersionBadgeCacheAccessor(MemcachedClientCache cache, WikiEditorDAO wikiEditorDAO) {
            super(cache, WikiEditorServiceCacheName.WIKI_EDITOR_VERSION_BADGES);
            this._wikiEditorDAO = wikiEditorDAO;
        }

        @Override
        protected WikiEditorId objectToKey(DBWikiVersionBadge dbResult) {
            return dbResult.getWikiEditorId();
        }

        @Override
        protected Iterable<DBWikiVersionBadge> getListFromDatabase(Set<? extends WikiEditorId> inputs) {
            return this._wikiEditorDAO.getWikiVersionBadgesByWikiEditorIds(inputs).values();
        }

        @Override
        protected String keyToString(WikiEditorId key) {
            return Long.toString(key.getId());
        }
    }

    private static enum WikiEditorServiceCacheName implements CacheName
    {
        WIKI_EDITOR_ID,
        WIKI_EDITOR_PARENT,
        WIKI_EDITOR_VERSION,
        WIKI_EDITOR_VERSIONS,
        WIKI_EDITOR_BACKUP,
        WIKI_EDITOR_CURRENT,
        WIKI_EDITOR_VERSION_BADGES,
        WIKI_EDITOR_VERSION_BY_ID;


        @Override
        public String getCacheName() {
            return this.name();
        }
    }
}

