/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.wikieditor.business;

import com.freiheit.toro.common.shared.model.PermissionDeniedException;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContextWithLocale;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContextWithUserId;
import de.justsoftware.onx.common.business.InvalidIDException;
import de.justsoftware.onx.common.deletion.DeletionContext;
import de.justsoftware.onx.common.shared.model.ListAndCount;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.container.business.EntityModuleHandler;
import de.justsoftware.onx.container.business.EntityTeaserResolver;
import de.justsoftware.onx.container.business.ProfileModuleHandler;
import de.justsoftware.onx.container.shared.model.GlobalId;
import de.justsoftware.onx.wikieditor.shared.model.DBWikiBackup;
import de.justsoftware.onx.wikieditor.shared.model.DBWikiEditor;
import de.justsoftware.onx.wikieditor.shared.model.WikiBackupId;
import de.justsoftware.onx.wikieditor.shared.model.WikiEditor;
import de.justsoftware.onx.wikieditor.shared.model.WikiEditorId;
import de.justsoftware.onx.wikieditor.shared.model.WikiPreEditResult;
import de.justsoftware.onx.wikieditor.shared.model.WikiVersion;
import de.justsoftware.onx.wikieditor.shared.model.WikiVersionBadge;
import de.justsoftware.onx.wikieditor.shared.model.WikiVersionId;
import de.justsoftware.onx.wikieditor.shared.server.model.DBWikiVersion;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface WikiEditorService
extends EntityModuleHandler,
ProfileModuleHandler,
EntityTeaserResolver {
    public DBWikiBackup getDBWikiBackupById(WikiBackupId var1);

    @Nonnull
    public WikiPreEditResult preEditCheck(@Nonnull WikiEditorId var1, @Nonnull WikiVersionId var2, @Nonnull AuthorizationCheckContextWithLocale var3) throws InvalidIDException;

    public Map<WikiBackupId, DBWikiBackup> getDBWikiBackupsByIds(Iterable<WikiBackupId> var1);

    @CheckForNull
    public DBWikiVersion getDBWikiVersionById(@Nonnull WikiVersionId var1);

    public Map<WikiVersionId, DBWikiVersion> getDBWikiVersionsById(Set<WikiVersionId> var1);

    @CheckForNull
    public DBWikiEditor getDBWikiEditorById(@Nonnull WikiEditorId var1);

    public Map<WikiEditorId, DBWikiEditor> getDBWikiEditorsByIds(Iterable<WikiEditorId> var1);

    @CheckForNull
    public DBWikiEditor getDBWikiEditorByParentId(GlobalId var1);

    @Nonnull
    public ImmutableMap<GlobalId, DBWikiEditor> getDBWikiEditorByParentIds(@Nonnull Set<? extends GlobalId> var1);

    public DBWikiVersion getCurrentDBWikiVersion(WikiEditorId var1);

    @Nonnull
    public ImmutableMap<WikiEditorId, DBWikiVersion> getCurrentWikiVersions(@Nonnull Set<WikiEditorId> var1);

    @Nonnull
    public WikiVersionId insertWikiVersion(DBWikiVersion var1, @Nullable Integer var2, boolean var3, boolean var4) throws InvalidIDException;

    public WikiVersion dbToWikiVersion(DBWikiVersion var1, @Nonnull AuthorizationCheckContextWithLocale var2);

    public void deleteWikiVersion(@Nonnull WikiVersionId var1, @Nonnull AuthorizationCheckContextWithUserId var2) throws PermissionDeniedException;

    public void saveWikiBackup(DBWikiBackup var1);

    public void deleteWikiBackup(WikiBackupId var1);

    public ListAndCount<WikiVersionBadge> getWikiVersionBadges(WikiEditorId var1, int var2, int var3, @Nonnull AuthorizationCheckContextWithLocale var4);

    public WikiEditor getWikiEditorById(DBWikiEditor var1, @Nonnull AuthorizationCheckContextWithLocale var2);

    @Nonnull
    public ImmutableSetMultimap<WikiEditorId, WikiVersionId> getWikiVersionIdsByWikiEditorIds(@Nonnull Set<WikiEditorId> var1);

    public void deleteDependentWikiVersions(@Nonnull Iterable<WikiVersionId> var1, @Nonnull Iterable<WikiEditorId> var2, @Nonnull DeletionContext var3);

    public void deleteDependentWikiEditor(@Nonnull WikiEditorId var1, @Nonnull GlobalId var2, @Nonnull DeletionContext var3);

    @Nonnull
    public ImmutableSet<WikiEditorId> getWikiBackupsForPersons(@Nonnull Set<PersonId> var1);

    public void deleteDependentWikiBackups(@Nonnull Set<WikiEditorId> var1, @Nonnull DeletionContext var2);

    @Nonnull
    public ImmutableMap<GlobalId, DBWikiVersion> getCurrentDBWikiVersionByParentId(@Nonnull Set<? extends GlobalId> var1);
}

