/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.visibility.integration.persistence.ibatis;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import com.ibatis.sqlmap.client.SqlMapClient;
import de.justsoftware.onx.common.integration.persistence.StatementBuilderFactory;
import de.justsoftware.onx.common.integration.persistence.ibatis.IbatisPartitionResultBuilder;
import de.justsoftware.onx.common.integration.persistence.ibatis.IbatisStatementBuilder;
import de.justsoftware.onx.common.shared.util.Multimaps2;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.visibility.integration.persistence.ItemVisibilityRoleDAO;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
@ParametersAreNonnullByDefault
public class IbatisItemVisibilityRoleDAO
implements ItemVisibilityRoleDAO {
    private final IbatisStatementBuilder _statementBuilder;

    @Autowired
    public IbatisItemVisibilityRoleDAO(StatementBuilderFactory statementBuilderFactory) {
        this._statementBuilder = statementBuilderFactory.ibatistStatementBuilder("ItemVisibilityRole");
    }

    @Override
    public void setItemRoleVisibilities(final Map<? extends ItemId, String> itemIdsAndOriginType, SetMultimap<? extends ItemId, String> rolesPerItem) {
        ImmutableSetMultimap<ItemId, String> existing = this.getItemRoleVisibilities(rolesPerItem.keySet());
        final SetMultimap<? extends ItemId, String> newVisibilities = Multimaps2.difference(rolesPerItem, existing);
        final SetMultimap<ItemId, String> deleteVisibilities = Multimaps2.difference(existing, rolesPerItem);
        final Sets.SetView deleteAllVisibilities = Sets.difference(itemIdsAndOriginType.keySet(), (Set)rolesPerItem.keySet());
        this._statementBuilder.batch(new IbatisStatementBuilder.BatchCallback(){

            @Override
            public void execute(SqlMapClient sqlMapClient) throws SQLException {
                IbatisItemVisibilityRoleDAO.this.deleteAllItemRoleVisibilities((Set<? extends ItemId>)deleteAllVisibilities);
                IbatisItemVisibilityRoleDAO.this._statementBuilder.delete("deleteItemRoleVisibilities").partition(deleteVisibilities.entries());
                for (Map.Entry e : newVisibilities.asMap().entrySet()) {
                    ItemId itemId = (ItemId)e.getKey();
                    String originType = (String)itemIdsAndOriginType.get(itemId);
                    if (originType == null) continue;
                    for (String role : (Collection)e.getValue()) {
                        IbatisItemVisibilityRoleDAO.this.insertItemRoleVisibility(itemId, role, originType);
                    }
                }
            }
        });
    }

    @Override
    public void insertItemRoleVisibility(ItemId itemId, String role, String originType) {
        this._statementBuilder.insertDbSpecific("insertItemRoleVisibility").param("itemId", itemId, "role", role, "originType", originType);
    }

    @Nonnull
    private ImmutableSetMultimap<ItemId, String> getItemRoleVisibilities(Set<? extends ItemId> itemids) {
        return ((IbatisPartitionResultBuilder)this._statementBuilder.select("getItemRoleVisibilities").partition(itemids)).asSetMultimap("itemId", "role");
    }

    @Override
    public ImmutableSet<String> getItemRoleVisibilities(ItemId itemId) {
        return this.getItemRoleVisibilities((Set<? extends ItemId>)ImmutableSet.of((Object)itemId)).get((Object)itemId);
    }

    @Override
    public void deleteAllItemRoleVisibilities(Set<? extends ItemId> itemIds) {
        this._statementBuilder.delete("deleteAllItemRoleVisibilities").partition(itemIds);
    }
}

