/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.visibility.business.impl;

import com.google.common.base.Functions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import de.justsoftware.onx.authorization.business.AuthorityUtil;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContext;
import de.justsoftware.onx.authorization.business.AuthorizationContextProvider;
import de.justsoftware.onx.authorization.business.PersonIndependentAuthorizationContext;
import de.justsoftware.onx.authorization.business.ProfileRole;
import de.justsoftware.onx.authorization.business.StaticRole;
import de.justsoftware.onx.common.business.configfile.ConfigFileService;
import de.justsoftware.onx.common.business.events.ServerEventHandler;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.model.Role;
import de.justsoftware.onx.common.shared.model.action.Action;
import de.justsoftware.onx.common.shared.model.action.StaticAction;
import de.justsoftware.onx.common.shared.model.action.StaticEntityAction;
import de.justsoftware.onx.container.business.EntityChildrenService;
import de.justsoftware.onx.container.business.EntityService;
import de.justsoftware.onx.container.business.ItemService;
import de.justsoftware.onx.container.business.events.EntityAdminChangedEvent;
import de.justsoftware.onx.container.business.events.EntityCreatedEvent;
import de.justsoftware.onx.container.business.events.EntityMemberRolesChangedEvent;
import de.justsoftware.onx.container.business.events.EntityMembershipChangedEvent;
import de.justsoftware.onx.container.business.events.EntityParentsChangedEvent;
import de.justsoftware.onx.container.business.events.EntityPrivacyChangedEvent;
import de.justsoftware.onx.container.business.events.ItemDeletedEvent;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.GlobalId;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.container.shared.model.db.DBEntityLink;
import de.justsoftware.onx.container.shared.model.db.DBPrivacyType;
import de.justsoftware.onx.container.shared.server.model.EntityItem;
import de.justsoftware.onx.container.shared.server.model.Item;
import de.justsoftware.onx.monitoring.business.QueueStatisticsService;
import de.justsoftware.onx.monitoring.business.model.QueueName;
import de.justsoftware.onx.person.model.DBPerson;
import de.justsoftware.onx.person.shared.server.model.ProfileItem;
import de.justsoftware.onx.searchnew.business.RolesSearchService;
import de.justsoftware.onx.searchnew.business.impl.RolesSearchServiceImpl;
import de.justsoftware.onx.visibility.business.VisibilityService;
import de.justsoftware.onx.visibility.business.VisibilityUpdateService;
import de.justsoftware.onx.visibility.business.VisibilityWriteDataService;
import de.justsoftware.onx.visibility.business.impl.EntityVisibilityEvent;
import de.justsoftware.onx.visibility.business.impl.VisibilityEvent;
import de.justsoftware.onx.visibility.integration.persistence.ItemVisibilityEventDAO;
import de.justsoftware.onx.visibility.shared.model.db.DBItemVisibilityEvent;
import de.justsoftware.onx.visibility.shared.model.db.ItemVisibilityEventId;
import de.justsoftware.onx.visibility.shared.server.model.VisibilityEventType;
import de.justsoftware.toolbox.guava.collect.Multimaps2;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service(value="visibilityService")
@Lazy(value=false)
@ParametersAreNonnullByDefault
public class VisibilityServiceImpl
implements ServerEventHandler,
VisibilityService,
VisibilityUpdateService {
    private static final Logger LOG = LoggerFactory.getLogger(VisibilityServiceImpl.class);
    private static final ImmutableSet<? extends Action> ENTITY_READ_DETAILS = ImmutableSet.of((Object)StaticEntityAction.ENTITY_READ_DETAILS);
    private static final long UNLOCK_EVENT_TIME = 900000L;
    private static final int QUEUE_FETCH_SIZE = 50;
    private static final ThreadLocal<Boolean> IS_IMPORT = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return Boolean.FALSE;
        }
    };
    private final EntityService _entityService;
    private final VisibilityWriteDataService _visibilityWriteDataService;
    private final AuthorizationContextProvider _authorizationContextProvider;
    private final ItemService _itemService;
    private final RolesSearchService _rolesSearchService;
    private final ItemVisibilityEventDAO _itemVisibilityEventDAO;
    private final EntityChildrenService _entityChildrenService;
    private final ConfigFileService _configFileService;
    private final QueueStatisticsService _queueStatService;

    @Autowired
    public VisibilityServiceImpl(EntityService entityService, VisibilityWriteDataService visibilityWriteDataService, AuthorizationContextProvider authorizationContextProvider, ItemService itemService, RolesSearchService rolesSearchService, ItemVisibilityEventDAO itemVisibilityEventDAO, EntityChildrenService entityChildrenService, ConfigFileService configFileService, QueueStatisticsService queueStatService) {
        this._entityService = entityService;
        this._visibilityWriteDataService = visibilityWriteDataService;
        this._authorizationContextProvider = authorizationContextProvider;
        this._itemService = itemService;
        this._rolesSearchService = rolesSearchService;
        this._itemVisibilityEventDAO = itemVisibilityEventDAO;
        this._entityChildrenService = entityChildrenService;
        this._configFileService = configFileService;
        this._queueStatService = queueStatService;
    }

    @Override
    public void processEvents() {
        ImmutableMap<ItemId, VisibilityEvent<?>> events = this.getNextEvents();
        if (events.isEmpty()) {
            return;
        }
        int processed = 0;
        while (!events.isEmpty()) {
            LOG.info("Processing {} visibility event(s)...", (Object)events.size());
            this.handleVisibilityEvents(events);
            processed += events.size();
            events = this.getNextEvents();
        }
        LOG.info("Finished processing {} visibility event(s).", (Object)processed);
    }

    private void handleVisibilityEvents(ImmutableMap<? extends ItemId, ? extends VisibilityEvent<?>> events) {
        FluentIterable fluentEvents = FluentIterable.from((Iterable)events.values());
        ImmutableMap items = this._itemService.getByIds(events.keySet());
        this.handleEntityVisibilityEvents(Iterables.filter((Iterable)events.values(), EntityVisibilityEvent.class), items);
        this._itemVisibilityEventDAO.deleteByIds((Set<ItemVisibilityEventId>)fluentEvents.transformAndConcat(VisibilityEvent.TO_EVENT_IDS).toSet());
    }

    @Nonnull
    private ImmutableMap<ItemId, VisibilityEvent<?>> getNextEvents() {
        this._itemVisibilityEventDAO.unlockStuckEvents(900000L);
        ImmutableList<DBItemVisibilityEvent> events = this._itemVisibilityEventDAO.fetchNextEvents(50);
        if (events.isEmpty()) {
            return ImmutableMap.of();
        }
        this._queueStatService.itemsDequeued(QueueName.ITEM_VISIBILITY, (Iterable<DateTime>)FluentIterable.from(events).transform(DBItemVisibilityEvent::getCreatedAt).toList());
        HashMultimap itemToEventIdMap = HashMultimap.create();
        ImmutableSetMultimap.Builder itemToEventTypeBuilder = ImmutableSetMultimap.builder();
        for (DBItemVisibilityEvent event : events) {
            Object eventTypesToAdd;
            GlobalId itemId = event.getItemId();
            ImmutableSet<VisibilityEventType> eventTypes = event.getEventTypesSet();
            if (!eventTypes.isEmpty()) {
                eventTypesToAdd = eventTypes;
            } else {
                if (!(itemId instanceof EntityId)) continue;
                eventTypesToAdd = EnumSet.of(VisibilityEventType.ENTITY_PARENTS, VisibilityEventType.ENTITY_VISIBILITY, VisibilityEventType.ENTITY_ADMINS, VisibilityEventType.ENTITY_MEMBERS);
            }
            itemToEventIdMap.put((Object)itemId, (Object)event.getId());
            itemToEventTypeBuilder.putAll((Object)itemId, eventTypesToAdd);
        }
        ImmutableSetMultimap itemToEventTypeMap = itemToEventTypeBuilder.build();
        ImmutableMap.Builder result = ImmutableMap.builder();
        for (Map.Entry itemEventIds : itemToEventIdMap.asMap().entrySet()) {
            GlobalId itemId = (GlobalId)itemEventIds.getKey();
            ImmutableSet eventIds = ImmutableSet.copyOf((Collection)((Collection)itemEventIds.getValue()));
            ImmutableSet eventTypes = itemToEventTypeMap.get((Object)itemId);
            if (!(itemId instanceof EntityId)) continue;
            result.put((Object)itemId, (Object)new EntityVisibilityEvent((ImmutableSet<VisibilityEventType>)eventTypes, (ImmutableSet<ItemVisibilityEventId>)eventIds, (EntityId)itemId));
        }
        return result.build();
    }

    private void updateEntityParents(ImmutableSetMultimap<VisibilityEventType, EntityId> events) {
        ImmutableSet toUpdate = events.get((Object)VisibilityEventType.ENTITY_PARENTS);
        ImmutableSetMultimap<EntityId, EntityId> parents = this._entityChildrenService.getAllEntityParents((Set<EntityId>)toUpdate);
        ImmutableSetMultimap parentsToSet = ImmutableSetMultimap.builder().putAll(parents).putAll((Iterable)FluentIterable.from((Iterable)toUpdate).toMap(Functions.identity()).entrySet()).build();
        this._visibilityWriteDataService.setEntityParents((SetMultimap<EntityId, EntityId>)parentsToSet);
        this._visibilityWriteDataService.deleteParentsAndChildren((Set<EntityId>)events.get((Object)VisibilityEventType.ENTITY_DELETED));
    }

    private void updateItems(Set<? extends GlobalId> itemIds, Map<ItemId, Item<?>> items, Set<? extends Action> actions) {
        ImmutableMap<ItemId, ImmutableSetMultimap<Action, Role>> allNeededRoles = this.getNeededRolesForActionsOnItem(itemIds, actions);
        ImmutableSetMultimap.Builder itemDependentRolesBuilder = ImmutableSetMultimap.builder();
        ImmutableMap.Builder itemIdsAndOriginType = ImmutableMap.builder();
        ImmutableSetMultimap.Builder rolesPerItem = ImmutableSetMultimap.builder();
        for (GlobalId globalId : itemIds) {
            Item<?> item = items.get(globalId);
            Multimap neededRoles = (Multimap)allNeededRoles.get((Object)globalId);
            if (this.isItemDeleted(item) || neededRoles == null) {
                itemIdsAndOriginType.put((Object)globalId, (Object)"");
                continue;
            }
            itemDependentRolesBuilder.putAll((Object)globalId, RolesSearchServiceImpl.getItemDependantRoles((Multimap<Action, ? extends Role>)neededRoles, actions));
            itemIdsAndOriginType.put((Object)globalId, (Object)this.getOriginType(item));
            ImmutableSet<Role> roles = RolesSearchServiceImpl.getStaticRoles((Multimap<Action, ? extends Role>)neededRoles, actions);
            rolesPerItem.putAll((Object)globalId, AuthorityUtil.names(roles));
        }
        ImmutableSetMultimap itemDependantRoles = itemDependentRolesBuilder.build();
        ImmutableMap<StaticRole, ImmutableSetMultimap<ItemId, PersonId>> immutableMap = this._rolesSearchService.getPersonIdsForItemDependantRoles((ImmutableSetMultimap<? extends ItemId, ? extends Role>)itemDependantRoles);
        for (Map.Entry e : itemDependantRoles.entries()) {
            Role role = (Role)e.getValue();
            GlobalId itemId = (GlobalId)e.getKey();
            ImmutableSetMultimap personsPerRole = (ImmutableSetMultimap)immutableMap.get((Object)role);
            if (personsPerRole == null) continue;
            for (PersonId person : personsPerRole.get((Object)itemId)) {
                rolesPerItem.put((Object)itemId, (Object)new ProfileRole(person).getName());
            }
        }
        this._visibilityWriteDataService.setItemRoleVisibilities((Map<? extends GlobalId, String>)itemIdsAndOriginType.build(), (SetMultimap<? extends GlobalId, String>)rolesPerItem.build());
    }

    @Nonnull
    private String getOriginType(Item<?> item) {
        if (item instanceof EntityItem) {
            return ((EntityItem)item).getEntity().getType().getName();
        }
        if (item instanceof ProfileItem) {
            return item.getId().getType().name();
        }
        throw new IllegalArgumentException("Unexpected item type " + item.getClass().getSimpleName());
    }

    private boolean isItemDeleted(@Nullable Item<?> item) {
        DBPerson person;
        if (item == null) {
            return true;
        }
        return item instanceof ProfileItem && ((person = ((ProfileItem)item).getPerson()).isDeleted() || !person.isActive());
    }

    @Nonnull
    private static <I extends ItemId> ImmutableSetMultimap<VisibilityEventType, I> indexByVisibilityEventType(Iterable<? extends VisibilityEvent<? extends I>> events) {
        ImmutableSetMultimap.Builder result = ImmutableSetMultimap.builder();
        for (VisibilityEvent<I> event : events) {
            for (VisibilityEventType v : event.getEventTypes()) {
                result.put((Object)v, event.getItemId());
            }
        }
        return result.build();
    }

    private void handleEntityVisibilityEvents(Iterable<EntityVisibilityEvent> events, ImmutableMap<ItemId, Item<?>> items) {
        ImmutableSetMultimap entitiesPerEventType = VisibilityServiceImpl.indexByVisibilityEventType(events);
        ImmutableSet updateEntities = VisibilityServiceImpl.getByEventTypes(entitiesPerEventType, VisibilityEventType.ENTITY_ADMINS, VisibilityEventType.ENTITY_MEMBERS, VisibilityEventType.ENTITY_MEMBER_ROLES, VisibilityEventType.ENTITY_VISIBILITY, VisibilityEventType.ENTITY_DELETED);
        this.updateItems((Set<? extends GlobalId>)updateEntities, (Map<ItemId, Item<?>>)items, (Set<? extends Action>)ENTITY_READ_DETAILS);
        this.updateEntityParents(entitiesPerEventType);
        this.propagateEvents(items, events);
    }

    @Nonnull
    private static <I> ImmutableSet<I> getByEventTypes(ImmutableSetMultimap<VisibilityEventType, I> itemsPerEventType, VisibilityEventType ... types) {
        SetMultimap items = Multimaps.filterKeys(itemsPerEventType, (Predicate)Predicates.in((Collection)ImmutableSet.copyOf((Object[])types)));
        return ImmutableSet.copyOf((Collection)items.values());
    }

    @CheckForNull
    private ImmutableMap<ItemId, ImmutableSetMultimap<Action, Role>> getNeededRolesForActionsOnItem(Set<? extends ItemId> items, Set<? extends Action> actions) {
        PersonIndependentAuthorizationContext authorizationContext = this._authorizationContextProvider.getPersonIndependentAuthorizationContext();
        ImmutableSetMultimap itemsAndActions = Multimaps2.cartesianProduct(items, actions);
        return authorizationContext.neededRolesForActions((SetMultimap<? extends ItemId, ? extends Action>)itemsAndActions);
    }

    private void propagateEvents(ImmutableMap<ItemId, Item<?>> items, Iterable<EntityVisibilityEvent> events) {
        Predicate itemExistPredicate = Predicates.compose((Predicate)Predicates.in((Collection)items.keySet()), VisibilityEvent.toItemIdFunction());
        ImmutableMap interestingEventsPerItem = FluentIterable.from(events).filter(itemExistPredicate).uniqueIndex(VisibilityEvent.toItemIdFunction());
        ImmutableListMultimap<EntityId, DBEntityLink> children = this._entityService.getDirectChildEntities((Set<EntityId>)interestingEventsPerItem.keySet());
        ImmutableSetMultimap.Builder newEvents = ImmutableSetMultimap.builder();
        for (EntityVisibilityEvent event : interestingEventsPerItem.values()) {
            for (DBEntityLink child : children.get((Object)event.getEntityId())) {
                if (event.containsAny(VisibilityEventType.ENTITY_PARENTS)) {
                    newEvents.put((Object)child.getEntityId(), (Object)VisibilityEventType.ENTITY_PARENTS);
                }
                if (event.containsAny(VisibilityEventType.ENTITY_ADMINS) && child.isInheritsAdmins()) {
                    newEvents.put((Object)child.getEntityId(), (Object)VisibilityEventType.ENTITY_ADMINS);
                }
                if (!event.containsAny(VisibilityEventType.ENTITY_MEMBERS) || !child.isInheritsMembers()) continue;
                newEvents.put((Object)child.getEntityId(), (Object)VisibilityEventType.ENTITY_MEMBERS);
            }
        }
        this.addEventsToQueue((SetMultimap<? extends GlobalId, VisibilityEventType>)newEvents.build());
    }

    private void addEventsToQueue(SetMultimap<? extends GlobalId, VisibilityEventType> newEvents) {
        this._itemVisibilityEventDAO.insertNewEvents(newEvents);
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onEntityCreated(EntityCreatedEvent event) {
        EntityId entityId = event.getEntityId();
        this.addEventsToQueue((SetMultimap<? extends GlobalId, VisibilityEventType>)ImmutableSetMultimap.of((Object)entityId, (Object)((Object)VisibilityEventType.ENTITY_PARENTS), (Object)entityId, (Object)((Object)VisibilityEventType.ENTITY_VISIBILITY), (Object)entityId, (Object)((Object)VisibilityEventType.ENTITY_MEMBERS), (Object)entityId, (Object)((Object)VisibilityEventType.ENTITY_ADMINS)));
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onEntityParentsChanged(EntityParentsChangedEvent event) {
        ImmutableSetMultimap.Builder newEvents = ImmutableSetMultimap.builder();
        if (event.isParentsChanged()) {
            newEvents.put((Object)event.getEntityId(), (Object)VisibilityEventType.ENTITY_PARENTS);
        }
        if (event.isAdminInheritanceChanged()) {
            newEvents.put((Object)event.getEntityId(), (Object)VisibilityEventType.ENTITY_ADMINS);
        }
        if (event.isMemberInheritanceChanged()) {
            newEvents.put((Object)event.getEntityId(), (Object)VisibilityEventType.ENTITY_MEMBERS);
        }
        this.addEventsToQueue((SetMultimap<? extends GlobalId, VisibilityEventType>)newEvents.build());
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onEntityPrivacyChange(EntityPrivacyChangedEvent event) {
        if (event.getChangedPrivacies().contains((Object)DBPrivacyType.VISIBILITY)) {
            this.addEventsToQueue((SetMultimap<? extends GlobalId, VisibilityEventType>)ImmutableSetMultimap.of((Object)event.getEntityId(), (Object)((Object)VisibilityEventType.ENTITY_VISIBILITY)));
        }
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onItemDeleted(ItemDeletedEvent event) {
        GlobalId itemId = event.getItemId();
        if (itemId instanceof EntityId) {
            this.addEventsToQueue((SetMultimap<? extends GlobalId, VisibilityEventType>)ImmutableSetMultimap.of((Object)itemId, (Object)((Object)VisibilityEventType.ENTITY_DELETED)));
        }
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onEntityMembershipChanged(EntityMembershipChangedEvent event) {
        ImmutableSetMultimap.Builder newEvents = ImmutableSetMultimap.builder();
        EntityId entityId = event.getEntityId();
        if (event.isBulk() || IS_IMPORT.get().booleanValue()) {
            newEvents.put((Object)entityId, (Object)VisibilityEventType.ENTITY_MEMBERS);
        } else {
            EntityVisibilityEvent visibilityEvent = new EntityVisibilityEvent((ImmutableSet<VisibilityEventType>)ImmutableSet.of((Object)((Object)VisibilityEventType.ENTITY_MEMBERS)), (ImmutableSet<ItemVisibilityEventId>)ImmutableSet.of(), entityId);
            this.handleVisibilityEvents(ImmutableMap.of((Object)entityId, (Object)visibilityEvent));
        }
        this.addEventsToQueue((SetMultimap<? extends GlobalId, VisibilityEventType>)newEvents.build());
    }

    @Override
    public void markCurrentThreadAsImport(boolean isImport) {
        IS_IMPORT.set(isImport);
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onEntityAdminChanged(EntityAdminChangedEvent event) {
        this.addEventsToQueue((SetMultimap<? extends GlobalId, VisibilityEventType>)ImmutableSetMultimap.of((Object)event.getEntityId(), (Object)((Object)VisibilityEventType.ENTITY_ADMINS)));
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onEntityMemberRolesChangedEvent(EntityMemberRolesChangedEvent event) {
        this.addEventsToQueue((SetMultimap<? extends GlobalId, VisibilityEventType>)ImmutableSetMultimap.of((Object)event.getEntityId(), (Object)((Object)VisibilityEventType.ENTITY_MEMBER_ROLES)));
    }

    @Override
    public void updateAll(AuthorizationCheckContext authorizationContext) {
        authorizationContext.check(StaticAction.ADMIN_VISIBILITY_REINDEX);
        this.updateAll();
    }

    @Override
    public void updateAll() {
        LOG.info("Reindex of all item visibilities triggered...");
        this._itemVisibilityEventDAO.deleteAllEvents();
        this._itemVisibilityEventDAO.insertForAllEntities();
    }

    @Override
    public long getQueueSize() {
        return this._itemVisibilityEventDAO.getQueueSize();
    }
}

