/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.visibility.business.impl;

import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.SetMultimap;
import de.justsoftware.onx.common.shared.server.TransactionHelper;
import de.justsoftware.onx.common.shared.util.Multimaps2;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.GlobalId;
import de.justsoftware.onx.visibility.business.VisibilityReadDataService;
import de.justsoftware.onx.visibility.business.VisibilityWriteDataService;
import de.justsoftware.onx.visibility.integration.persistence.EntityParentsDAO;
import de.justsoftware.onx.visibility.integration.persistence.ItemVisibilityRoleDAO;
import de.justsoftware.onx.workstream.business.WorkstreamDataService;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;

@Service
public class VisibilityReadWriteDataService
implements VisibilityReadDataService,
VisibilityWriteDataService {
    @Autowired
    private EntityParentsDAO _entityParentsDAO;
    @Autowired
    private ItemVisibilityRoleDAO _itemVisibilityRoleDAO;
    @Autowired
    private WorkstreamDataService _workstreamDataService;
    @Autowired
    private TransactionHelper _transactionHelper;

    @Override
    public void setEntityParents(SetMultimap<EntityId, EntityId> parentsPerChild) {
        ImmutableSetMultimap<EntityId, EntityId> existingParents = this._entityParentsDAO.getEntityParents(parentsPerChild.keySet());
        final SetMultimap<EntityId, EntityId> newParents = Multimaps2.difference(parentsPerChild, existingParents);
        final SetMultimap<EntityId, EntityId> deleteParents = Multimaps2.difference(existingParents, parentsPerChild);
        this._transactionHelper.doInTransactionWithoutResult(new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                VisibilityReadWriteDataService.this._entityParentsDAO.deleteParents((SetMultimap<EntityId, EntityId>)deleteParents);
                VisibilityReadWriteDataService.this._entityParentsDAO.insertNewParents((SetMultimap<EntityId, EntityId>)newParents);
            }
        });
        this._workstreamDataService.invalidateIndirectParents(Iterables.concat((Iterable)newParents.values(), (Iterable)deleteParents.values()));
    }

    @Override
    public void setItemRoleVisibilities(Map<? extends GlobalId, String> itemIdsAndOriginType, SetMultimap<? extends GlobalId, String> rolesPerItem) {
        this._itemVisibilityRoleDAO.setItemRoleVisibilities(itemIdsAndOriginType, rolesPerItem);
    }

    @Override
    public void deleteParentsAndChildren(Set<EntityId> deleted) {
        this._entityParentsDAO.deleteParentsAndChildren(deleted);
    }
}

