/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.visibility.business.impl;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.util.shared.NullIsFalsePredicate;
import de.justsoftware.onx.util.shared.NullPermeableFunction;
import de.justsoftware.onx.visibility.shared.model.db.ItemVisibilityEventId;
import de.justsoftware.onx.visibility.shared.server.model.VisibilityEventType;
import javax.annotation.Nonnull;

abstract class VisibilityEvent<I extends ItemId> {
    public static final Function<VisibilityEvent<?>, ImmutableSet<ItemVisibilityEventId>> TO_EVENT_IDS = new NullPermeableFunction<VisibilityEvent<?>, ImmutableSet<ItemVisibilityEventId>>(){

        @Override
        protected ImmutableSet<ItemVisibilityEventId> applySafe(VisibilityEvent<?> input) {
            return input.getEventIds();
        }
    };
    private final ImmutableSet<VisibilityEventType> _eventTypes;
    private final ImmutableSet<ItemVisibilityEventId> _eventIds;

    public VisibilityEvent(@Nonnull ImmutableSet<VisibilityEventType> eventTypes, @Nonnull ImmutableSet<ItemVisibilityEventId> eventIds) {
        this._eventTypes = eventTypes;
        this._eventIds = eventIds;
    }

    public boolean containsAny(VisibilityEventType ... eventTypes) {
        for (VisibilityEventType eventType : eventTypes) {
            if (!this._eventTypes.contains((Object)eventType)) continue;
            return true;
        }
        return false;
    }

    @Nonnull
    public static Predicate<VisibilityEvent<?>> containsAnyPredicate(final VisibilityEventType ... eventTypes) {
        return new NullIsFalsePredicate<VisibilityEvent<?>>(){

            @Override
            protected boolean applySafe(VisibilityEvent<?> input) {
                for (VisibilityEventType eventType : eventTypes) {
                    if (!input._eventTypes.contains((Object)eventType)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    @Nonnull
    public ImmutableSet<ItemVisibilityEventId> getEventIds() {
        return this._eventIds;
    }

    public String toString() {
        if (this._eventTypes == null) {
            return "<empty>";
        }
        return "event types " + this._eventTypes.toString() + " containing " + this._eventIds.size() + " event ID(s)";
    }

    @Nonnull
    public static <I extends ItemId> Function<VisibilityEvent<? extends I>, I> toItemIdFunction() {
        return new NullPermeableFunction<VisibilityEvent<? extends I>, I>(){

            @Override
            protected I applySafe(VisibilityEvent<? extends I> input) {
                return input.getItemId();
            }
        };
    }

    public ImmutableSet<VisibilityEventType> getEventTypes() {
        return this._eventTypes;
    }

    @Nonnull
    protected abstract I getItemId();
}

