/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.videolink.shared.util;

import com.google.gwt.regexp.shared.RegExp;
import javax.annotation.Nonnull;

public class VideolinkHosters {
    public static final int LONG_YOUTUBE_URL_ID_PARAM = 3;
    public static final int SHORT_YOUTUBE_URL_ID_PARAM = 1;
    private static final String HTTP_OR_HTTPS = "(https?://)?";
    private static final String WWW = "(www\\.)?";
    private static final String LONG_YOUTUBE_URL = "(https?://)?(www\\.)?youtube\\.com/watch\\?.*v=([^&]+).*";
    private static final String SHORT_YOUTUBE_URL = "(https?://)?youtu\\.be/([^&]*).*";
    private static final String VIMEO_URL = "(https?://)?(www\\.)?vimeo\\.com/.*";

    public static boolean isVideoUrlSupported(@Nonnull String videoUrl) {
        return VideolinkHosters.getLongYoutubeRegExp().test(videoUrl) || VideolinkHosters.getShortYoutubeRegexp().test(videoUrl) || VideolinkHosters.getVimeoRegexp().test(videoUrl);
    }

    @Nonnull
    public static RegExp getVimeoRegexp() {
        return RegExp.compile((String)VIMEO_URL, (String)"i");
    }

    @Nonnull
    public static RegExp getShortYoutubeRegexp() {
        return RegExp.compile((String)SHORT_YOUTUBE_URL, (String)"i");
    }

    @Nonnull
    public static RegExp getLongYoutubeRegExp() {
        return RegExp.compile((String)LONG_YOUTUBE_URL, (String)"i");
    }
}

