/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.videolink.shared.server.model;

import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import de.justsoftware.onx.common.shared.model.component.ComponentType;
import de.justsoftware.onx.common.shared.model.component.StaticComponentType;
import de.justsoftware.onx.container.shared.model.GlobalId;
import de.justsoftware.onx.container.shared.server.model.Item;
import de.justsoftware.onx.container.shared.server.model.ItemVisitor;
import de.justsoftware.onx.videolink.shared.model.DBVideolink;
import de.justsoftware.onx.videolink.shared.model.VideolinkId;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class VideolinkItem
implements Item<VideolinkId> {
    public static final Function<DBVideolink, VideolinkItem> FROM_DBLINK = new Function<DBVideolink, VideolinkItem>(){

        public VideolinkItem apply(DBVideolink input) {
            return VideolinkItem.of(input);
        }
    };
    private final DBVideolink _link;

    public VideolinkItem(@Nonnull DBVideolink link) {
        this._link = link;
    }

    @CheckForNull
    public static VideolinkItem of(@Nullable DBVideolink videoLink) {
        return videoLink != null ? new VideolinkItem(videoLink) : null;
    }

    public DBVideolink getLink() {
        return this._link;
    }

    @Override
    public VideolinkId getId() {
        return this._link.getId();
    }

    @Override
    public GlobalId getParentId() {
        return this._link.getParentId();
    }

    @Override
    public ComponentType getModuleType() {
        return StaticComponentType.VIDEOLINK;
    }

    @Override
    public <T> T accept(ItemVisitor<T> v) {
        return v.visit(this);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("link", (Object)this._link).toString();
    }
}

