/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.videolink.business.impl;

import com.freiheit.toro.cache.CacheKey;
import com.freiheit.toro.cache.CacheName;
import com.freiheit.toro.cache.memcached.MemcachedClientCache;
import com.freiheit.toro.common.shared.server.storage.StorageServerHelper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gwt.regexp.shared.MatchResult;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContextWithLocale;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContextWithUserId;
import de.justsoftware.onx.authorization.business.SearchAuthorizationCheckContext;
import de.justsoftware.onx.common.business.CacheHelper;
import de.justsoftware.onx.common.business.InternalLinkService;
import de.justsoftware.onx.common.business.InvalidIDException;
import de.justsoftware.onx.common.business.ServerUrlUtil;
import de.justsoftware.onx.common.business.events.JCEventBus;
import de.justsoftware.onx.common.business.events.util.ServerEventCollector;
import de.justsoftware.onx.common.cache.UniDirectionalCacheAccessor;
import de.justsoftware.onx.common.deletion.DeleteTransactionCallback;
import de.justsoftware.onx.common.deletion.DeletionContext;
import de.justsoftware.onx.common.deletion.DeletionService;
import de.justsoftware.onx.common.deletion.TransactionCallbackWithDeleteAction;
import de.justsoftware.onx.common.deletion.model.DeleteAction;
import de.justsoftware.onx.common.shared.model.ListAndCount;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.model.action.Action;
import de.justsoftware.onx.common.shared.model.action.StaticAction;
import de.justsoftware.onx.common.shared.model.component.ComponentType;
import de.justsoftware.onx.common.shared.server.util.BeanUtil;
import de.justsoftware.onx.common.shared.server.util.DOMUtil;
import de.justsoftware.onx.common.shared.server.util.HtmlParserUtil;
import de.justsoftware.onx.container.business.events.ItemDeletedEvent;
import de.justsoftware.onx.container.shared.model.GlobalId;
import de.justsoftware.onx.container.shared.model.Identifiables;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.container.shared.model.ModuleData;
import de.justsoftware.onx.container.shared.model.db.DBEntity;
import de.justsoftware.onx.container.shared.server.model.EntityItem;
import de.justsoftware.onx.container.shared.server.model.Item;
import de.justsoftware.onx.person.shared.model.PersonTeaserModel;
import de.justsoftware.onx.person.shared.server.model.ProfileItem;
import de.justsoftware.onx.profile.business.ProfileTeaserService;
import de.justsoftware.onx.util.server.EncodingUtil;
import de.justsoftware.onx.util.shared.NullPermeableFunction;
import de.justsoftware.onx.videolink.business.VideoConfig;
import de.justsoftware.onx.videolink.business.VideolinkServiceTestInterface;
import de.justsoftware.onx.videolink.business.events.VideolinkCreatedEvent;
import de.justsoftware.onx.videolink.integration.persistence.VideolinkDAO;
import de.justsoftware.onx.videolink.shared.model.DBVideolink;
import de.justsoftware.onx.videolink.shared.model.GwtOembedVideoData;
import de.justsoftware.onx.videolink.shared.model.OembedVideoData;
import de.justsoftware.onx.videolink.shared.model.VideoHoster;
import de.justsoftware.onx.videolink.shared.model.Videolink;
import de.justsoftware.onx.videolink.shared.model.VideolinkId;
import de.justsoftware.onx.videolink.shared.model.VideolinkModuleData;
import de.justsoftware.onx.videolink.shared.server.model.VideolinkItem;
import de.justsoftware.onx.videolink.shared.util.VideolinkHosters;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.TransactionStatus;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

@Service
@ParametersAreNonnullByDefault
public class VideolinkServiceImpl
implements VideolinkServiceTestInterface {
    private static final String MOVIE_IMAGE = "movie.png";
    private static final long OEMBED_CACHE_EXPIRE = TimeUnit.DAYS.toSeconds(1L);
    private static final String YOUTUBE_EMBED_SNIPPET = "<object><param name=\"movie\" value=\"//www.youtube.com/v/%s\"></param><param name=\"allowFullScreen\" value=\"true\"></param><param name=\"allowscriptaccess\" value=\"always\"></param><embed src=\"//www.youtube.com/v/%<s\" type=\"application/x-shockwave-flash\" allowscriptaccess=\"always\"allowfullscreen=\"true\"></embed></object>";
    private static final String YOUTUBE_IMAGE_URL = "//img.youtube.com/vi/%s/default.jpg";
    private static final Logger LOG = LoggerFactory.getLogger(VideolinkServiceImpl.class);
    private static final ImmutableSet<? extends Action> VIDEOLINK_LIST_CHECK_ACTIONS = ImmutableSet.of((Object)StaticAction.VIDEOLINK_CREATE, (Object)StaticAction.VIDEOLINK_SHOW_ACTIONS);
    private static final ImmutableSet<? extends Action> VIDEOLINK_CHECK_ACTIONS = ImmutableSet.of((Object)StaticAction.VIDEOLINK_UPDATE, (Object)StaticAction.VIDEOLINK_DELETE, (Object)StaticAction.VIDEOLINK_SHOW_ACTIONS, (Object)StaticAction.COMMENT_CREATE);
    @Autowired
    private CacheHelper _cacheHelper;
    private final MemcachedClientCache _cache;
    private final VideolinkDAO _videolinkDAO;
    @Autowired
    private VideoConfig _videoConfig;
    @Autowired
    private ProfileTeaserService _profileTeaserService;
    @Autowired
    private InternalLinkService _internalLinkService;
    @Autowired
    private DeletionService _deletionService;
    @Autowired
    private StorageServerHelper _storageServerHelper;
    @Autowired
    private ServerUrlUtil _urlUtil;
    @Autowired
    private JCEventBus _eventBus;
    private final CacheHelper.GetByOffsetLimitInterface<VideolinkId, DBVideolink, Videolink, GlobalId, AuthorizationCheckContextWithLocale> _bulkVideolink = new CacheHelper.GetByOffsetLimitInterface<VideolinkId, DBVideolink, Videolink, GlobalId, AuthorizationCheckContextWithLocale>(){

        @Override
        public List<VideolinkId> getIds(GlobalId parentId) {
            return ((ImmutableSet)VideolinkServiceImpl.this._videolinkIdsByParentCacheAccessor.getSingle(parentId)).asList();
        }

        @Override
        public Iterable<Videolink> map(Iterable<DBVideolink> ds, AuthorizationCheckContextWithLocale authorizationContext) {
            Map<VideolinkId, Videolink> r = VideolinkServiceImpl.this.dbToVideolink((Map<VideolinkId, DBVideolink>)Maps.uniqueIndex(ds, Identifiables.toId()), authorizationContext);
            return FluentIterable.from(ds).transform(Identifiables.toId()).transform(Functions.forMap(r, null)).filter(Predicates.notNull());
        }

        @Override
        public CacheKey cacheKey(VideolinkId id) {
            return VideolinkServiceImpl.videolinkCacheKey(id);
        }

        @Override
        public Map<VideolinkId, DBVideolink> ibatisGetByIds(Set<VideolinkId> ids) {
            return VideolinkServiceImpl.this._videolinkDAO.getByIds(ids);
        }
    };
    private final UniDirectionalCacheAccessor<VideoLinkServiceCacheName, GlobalId, VideolinkId> _videolinkIdsByParentCacheAccessor;

    @Autowired
    @ParametersAreNonnullByDefault
    public VideolinkServiceImpl(MemcachedClientCache cache, VideolinkDAO videolinkDAO) {
        this._cache = cache;
        this._videolinkDAO = videolinkDAO;
        this._videolinkIdsByParentCacheAccessor = VideolinkServiceImpl.createVideolinkIdsByParentCacheAccessor(cache, videolinkDAO);
    }

    @Nonnull
    private static UniDirectionalCacheAccessor<VideoLinkServiceCacheName, GlobalId, VideolinkId> createVideolinkIdsByParentCacheAccessor(MemcachedClientCache cache, VideolinkDAO videolinkDAO) {
        return new UniDirectionalCacheAccessor<VideoLinkServiceCacheName, GlobalId, VideolinkId>(cache, VideoLinkServiceCacheName.VIDEOLINK_IDS, videolinkDAO::getIdsByParentIds, ItemId::asString);
    }

    @Nonnull
    private static CacheKey videolinkCacheKey(VideolinkId id) {
        return new CacheKey((CacheName)VideoLinkServiceCacheName.VIDEOLINK, id);
    }

    @Nonnull
    private static CacheKey videolinkOembedCachKey(String url) {
        return new CacheKey((CacheName)VideoLinkServiceCacheName.VIDEOLINK_OEMBED, url);
    }

    @Override
    public VideoHoster getVideoHoster(final String videoUrl) {
        if (StringUtils.isBlank((String)videoUrl)) {
            return null;
        }
        return (VideoHoster)((Object)Iterables.find(VideoHoster.ALL, (Predicate)new VideoHoster.VisitorPredicate(){

            @Override
            public Boolean visitYoutube() {
                return VideolinkHosters.getLongYoutubeRegExp().test(videoUrl) || VideolinkHosters.getShortYoutubeRegexp().test(videoUrl);
            }

            @Override
            public Boolean visitVimeo() {
                return VideolinkHosters.getVimeoRegexp().test(videoUrl);
            }

            @Override
            public Boolean visitSelfHosted() {
                return videoUrl.matches(VideolinkServiceImpl.this._videoConfig.getOEmbedTokenPrefix() + ".*");
            }
        }, null));
    }

    @Nonnull
    private static String prependProtocolIfNecessary(String videoUrl) {
        if (videoUrl.matches("(([^:]+://)|#).*")) {
            return videoUrl;
        }
        return "http://" + videoUrl;
    }

    @Override
    public String getOEmbedUrl(final String videoUrl, VideoHoster videoHoster) {
        return videoHoster.accept(new VideoHoster.Visitor<String>(){

            @Override
            public String visitYoutube() {
                return "https://www.youtube.com/oembed?url=" + EncodingUtil.encodeURL(VideolinkServiceImpl.prependProtocolIfNecessary(videoUrl)) + "&format=json";
            }

            @Override
            public String visitVimeo() {
                return "https://vimeo.com/api/oembed.json?url=" + EncodingUtil.encodeURL(VideolinkServiceImpl.prependProtocolIfNecessary(videoUrl));
            }

            @Override
            public String visitSelfHosted() {
                return VideolinkServiceImpl.this._urlUtil.getSystemProtocol() + "://" + VideolinkServiceImpl.this._urlUtil.getSystemDomain() + ":" + VideolinkServiceImpl.this._urlUtil.getSystemPort() + "/" + VideolinkServiceImpl.this._urlUtil.getCommonResourcePrefix() + "/video/oembed.json?url=" + EncodingUtil.encodeURL(videoUrl);
            }
        });
    }

    @CheckForNull
    private GwtOembedVideoData getOEmbed(String videoUrl) {
        return (GwtOembedVideoData)this.getOEmbed((Set<String>)ImmutableSet.of((Object)videoUrl)).get((Object)videoUrl);
    }

    @Nonnull
    private ImmutableMap<String, GwtOembedVideoData> getOEmbed(Set<String> videoUrls) {
        HashSet cacheKeys = Sets.newHashSet();
        LinkedList interimResults = Lists.newLinkedList();
        for (String videoUrl : videoUrls) {
            VideoHoster videoHoster = this.getVideoHoster(videoUrl);
            if (videoHoster == null) {
                LOG.warn("The video hoster for the video URL {} could not be detected", (Object)videoUrl);
                continue;
            }
            String oEmbedUrlString = this.getOEmbedUrl(videoUrl, videoHoster);
            CacheKey key = VideolinkServiceImpl.videolinkOembedCachKey(oEmbedUrlString);
            cacheKeys.add(key);
            interimResults.add(new OembedInterimResult(videoUrl, videoHoster, oEmbedUrlString, key));
        }
        Map cached = this._cache.getBulk(cacheKeys);
        ImmutableMap.Builder result = ImmutableMap.builder();
        for (OembedInterimResult entry : interimResults) {
            GwtOembedVideoData newResult;
            Optional cachedResponse = (Optional)cached.get(entry._cacheKey);
            if (cachedResponse != null) {
                if (!cachedResponse.isPresent()) continue;
                result.put((Object)entry._videoUrl, (Object)((GwtOembedVideoData)cachedResponse.get()));
                continue;
            }
            OembedVideoData videoData = this.loadOrCreateManually(entry);
            if (videoData != null) {
                newResult = new GwtOembedVideoData(videoData);
                result.put((Object)entry._videoUrl, (Object)newResult);
            } else {
                newResult = null;
            }
            this._cache.add(entry._cacheKey, Optional.fromNullable((Object)newResult), OEMBED_CACHE_EXPIRE);
        }
        return result.build();
    }

    @CheckForNull
    private OembedVideoData loadOrCreateManually(OembedInterimResult entry) {
        try {
            String loadedResponse = IOUtils.toString((InputStream)new URL(entry._oEmbedUrlString).openConnection().getInputStream(), (String)Charsets.UTF_8.name());
            return this.transformOembed(entry._videoHoster, new JsonOembedVideoData(new JSONObject(loadedResponse)));
        }
        catch (MalformedURLException e) {
            return this.buildManually(entry, e);
        }
        catch (IOException e) {
            return this.buildManually(entry, e);
        }
        catch (JSONException e) {
            return this.buildManually(entry, (Exception)((Object)e));
        }
    }

    @Override
    public OembedVideoData transformOembed(VideoHoster videoHoster, final OembedVideoData result) {
        return videoHoster.accept(new VideoHoster.Visitor<OembedVideoData>(){

            @Override
            public OembedVideoData visitYoutube() {
                return VideolinkServiceImpl.this.addWmodeTransparent(VideolinkServiceImpl.this.convertToProtocolRelative(result));
            }

            @Override
            public OembedVideoData visitSelfHosted() {
                return VideolinkServiceImpl.this.convertToProtocolRelative(result);
            }

            @Override
            public OembedVideoData visitVimeo() {
                return VideolinkServiceImpl.this.convertToProtocolRelative(result);
            }
        });
    }

    @Nonnull
    protected OembedVideoData addWmodeTransparent(OembedVideoData data) {
        return new DelegatingOembedVideoData(data){

            @Override
            public String getHtml() {
                String superHtml = super.getHtml();
                try {
                    Document parsed = HtmlParserUtil.parseHtml(superHtml);
                    NodeList iframes = parsed.getElementsByTagName("iframe");
                    if (iframes.getLength() == 0) {
                        LOG.error("error parsing youtube html:\n" + superHtml);
                        return superHtml;
                    }
                    Node first = iframes.item(0);
                    String src = DOMUtil.getAttributeValue(first, "src");
                    if (StringUtils.isBlank((String)src)) {
                        LOG.error("error parsing youtube html:\n" + superHtml);
                        return superHtml;
                    }
                    return superHtml.replace(src, src + "&wmode=transparent");
                }
                catch (SAXException e) {
                    LOG.error("error parsing youtube html:\n" + superHtml, (Throwable)e);
                    return superHtml;
                }
                catch (IOException e) {
                    LOG.error("error parsing youtube html:\n" + superHtml, (Throwable)e);
                    return superHtml;
                }
            }
        };
    }

    @CheckForNull
    @VisibleForTesting
    OembedVideoData buildManually(final OembedInterimResult entry, Exception ex) {
        LOG.info("Could not load JSON from " + entry, (Throwable)ex);
        return (OembedVideoData)entry._videoHoster.accept(new VideoHoster.Visitor<Optional<OembedVideoData>>(){

            @Override
            public Optional<OembedVideoData> visitYoutube() {
                String videoId;
                MatchResult longUrlMatcher = VideolinkHosters.getLongYoutubeRegExp().exec(entry._videoUrl);
                if (longUrlMatcher != null) {
                    videoId = longUrlMatcher.getGroup(3);
                } else {
                    MatchResult shortUrlMatcher = VideolinkHosters.getShortYoutubeRegexp().exec(entry._videoUrl);
                    if (shortUrlMatcher != null) {
                        videoId = shortUrlMatcher.getGroup(1);
                    } else {
                        return Optional.absent();
                    }
                }
                return Optional.of((Object)new OembedVideoData(){

                    @Override
                    public String getTitle() {
                        return "";
                    }

                    @Override
                    public String getThumbnailUrl() {
                        return String.format(VideolinkServiceImpl.YOUTUBE_IMAGE_URL, videoId);
                    }

                    @Override
                    public String getHtml() {
                        return String.format(VideolinkServiceImpl.YOUTUBE_EMBED_SNIPPET, videoId);
                    }
                });
            }

            @Override
            public Optional<OembedVideoData> visitSelfHosted() {
                return Optional.absent();
            }

            @Override
            public Optional<OembedVideoData> visitVimeo() {
                return Optional.absent();
            }
        }).orNull();
    }

    @Nonnull
    private OembedVideoData convertToProtocolRelative(OembedVideoData result) {
        return new DelegatingOembedVideoData(result){

            @Override
            public String getHtml() {
                return this.replace(super.getHtml());
            }

            @Override
            public String getThumbnailUrl() {
                String thumbnailUrl = super.getThumbnailUrl();
                if (StringUtils.isBlank((String)thumbnailUrl)) {
                    return VideolinkServiceImpl.this._videoConfig.getDefaultPublicThumbnailUrl();
                }
                return this.replace(thumbnailUrl);
            }

            @Nonnull
            private String replace(@Nonnull String s) {
                return s.replaceAll("(?i)https?:\\/\\/", "//");
            }
        };
    }

    @Nonnull
    private Map<VideolinkId, Videolink> dbToVideolink(Map<VideolinkId, DBVideolink> dbVideolink, final AuthorizationCheckContextWithLocale authorizationContext) {
        ImmutableSet authorIds = FluentIterable.from(dbVideolink.values()).transform(DBVideolink.GET_AUTHOR_ID).filter(Predicates.notNull()).toSet();
        final ImmutableMap<PersonId, PersonTeaserModel> authors = this._profileTeaserService.getPersonTeasersByIds((Set<PersonId>)authorIds, authorizationContext);
        final ImmutableSetMultimap may = authorizationContext.may(FluentIterable.from(dbVideolink.values()).transform(VideolinkItem.FROM_DBLINK), VIDEOLINK_CHECK_ACTIONS);
        ImmutableSet urls = FluentIterable.from(dbVideolink.values()).transform(DBVideolink.GET_URL).filter(Predicates.notNull()).toSet();
        final ImmutableMap<String, GwtOembedVideoData> oembed = this.getOEmbed((Set<String>)urls);
        return Maps.transformValues(dbVideolink, (Function)new NullPermeableFunction<DBVideolink, Videolink>(){

            @Override
            protected Videolink applySafe(DBVideolink input) {
                Videolink videolink = BeanUtil.createBeanFromChildBean(Videolink.class, input);
                GwtOembedVideoData obj = (GwtOembedVideoData)oembed.get((Object)input.getUrl());
                if (obj == null) {
                    return null;
                }
                videolink.setEmbedHTML(obj.getHtml());
                videolink.setThumbnailURL(obj.getThumbnailUrl());
                videolink.setAuthor((PersonTeaserModel)authors.get((Object)videolink.getAuthorId()));
                videolink.setMay((Set<Action>)may.get((Object)Optional.of((Object)input.getId())));
                videolink.setIconUrl(VideolinkServiceImpl.MOVIE_IMAGE);
                if (videolink.isInternalVideo()) {
                    videolink.setUrl(VideolinkServiceImpl.this._internalLinkService.linkToItemAbsolute(new VideolinkItem(videolink), authorizationContext).getHref());
                }
                return videolink;
            }
        });
    }

    @Override
    public GwtOembedVideoData getBaseData(String videoUrl) throws JSONException {
        return this.getOEmbed(videoUrl);
    }

    @Override
    public DBVideolink getDBVideolinkById(VideolinkId id) {
        return this.getDBVideolinksByIds((Set<VideolinkId>)ImmutableSet.of((Object)id)).get(id);
    }

    @Override
    public Map<VideolinkId, DBVideolink> getDBVideolinksByIds(Set<VideolinkId> ids) {
        return this._cacheHelper.getByIdsMap(ids, this._bulkVideolink);
    }

    @Override
    public void create(ComponentType componentType, Iterable<DBEntity> entities, ServerEventCollector eventCollector) {
    }

    @Override
    public void create(ProfileItem parentProfileItem, ComponentType componentType, ServerEventCollector eventCollector) {
    }

    @Override
    public void deleteVideolink(final VideolinkId id, AuthorizationCheckContextWithUserId authorizationContext) {
        final DBVideolink dbVideolink = this.getDBVideolinkById(id);
        if (dbVideolink == null) {
            return;
        }
        authorizationContext.check((ItemId)id, (Action)StaticAction.VIDEOLINK_DELETE);
        DeleteTransactionCallback callback = this._deletionService.deleteInTransactionWithDeleteAction(id, authorizationContext.getUserId(), new TransactionCallbackWithDeleteAction<DeleteTransactionCallback>(){

            @Override
            public DeleteTransactionCallback doInTransactionWithDeleteAction(TransactionStatus status, DeleteAction deleteAction) {
                return VideolinkServiceImpl.this.delete((Set<VideolinkId>)ImmutableSet.of((Object)id), (Set<? extends ItemId>)ImmutableSet.of((Object)dbVideolink.getParentId()));
            }
        });
        callback.afterCommit();
        this._eventBus.post(new ItemDeletedEvent(id));
    }

    @Override
    public void deleteDependentVideolinks(Set<VideolinkId> videoIds, Set<GlobalId> parentIds, DeletionContext deletionContext) {
        if (videoIds.isEmpty()) {
            return;
        }
        DeleteTransactionCallback callback = this.delete(videoIds, parentIds);
        deletionContext.attach(callback);
    }

    @Override
    public DeleteTransactionCallback deleteDependentVideolinks(Set<VideolinkId> videoIds, Set<ItemId> parentIds) {
        if (videoIds.isEmpty()) {
            return DeleteTransactionCallback.DO_NOTHING_CALLBACK;
        }
        return this.delete(videoIds, parentIds);
    }

    @Nonnull
    private DeleteTransactionCallback delete(Set<VideolinkId> videoIds, final Set<? extends ItemId> parentIds) {
        Map<VideolinkId, DBVideolink> videolinks = this.getDBVideolinksByIds(videoIds);
        ImmutableSet.Builder filenameBuilder = ImmutableSet.builder();
        for (DBVideolink videolink : videolinks.values()) {
            String filename = videolink.getFileName();
            if (filename == null) continue;
            filenameBuilder.add((Object)filename);
        }
        final ImmutableSet filenames = filenameBuilder.build();
        this._videolinkDAO.deleteByIds(videoIds);
        ImmutableSet.Builder cacheKeyBuilder = ImmutableSet.builder();
        for (VideolinkId videoId : videoIds) {
            cacheKeyBuilder.add((Object)VideolinkServiceImpl.videolinkCacheKey(videoId));
        }
        final ImmutableSet cacheKeys = cacheKeyBuilder.build();
        return new DeleteTransactionCallback(){

            @Override
            public void afterCommit() {
                VideolinkServiceImpl.this._cacheHelper.delete((ImmutableSet<CacheKey>)cacheKeys);
                VideolinkServiceImpl.this._videolinkIdsByParentCacheAccessor.invalidateKeys((Iterable<GlobalId>)FluentIterable.from((Iterable)parentIds).filter(GlobalId.class));
                for (String filename : filenames) {
                    VideolinkServiceImpl.this._storageServerHelper.deleteGenericFileOnStorageServer(VideolinkServiceImpl.this._videoConfig.getVideoStorageBasePath(), filename);
                }
            }
        };
    }

    @Override
    public ModuleData getModuleData(SearchAuthorizationCheckContext authorizationContext, EntityItem entity, ComponentType componentType) throws InvalidIDException {
        return this.getModuleData(authorizationContext, entity);
    }

    @Override
    public ModuleData getModuleData(SearchAuthorizationCheckContext authorizationContext, ProfileItem person, ComponentType componentType) throws InvalidIDException {
        return this.getModuleData(authorizationContext, person);
    }

    @Nonnull
    private ModuleData getModuleData(SearchAuthorizationCheckContext authorizationContext, Item<? extends GlobalId> parent) {
        return new VideolinkModuleData(this.getNewestVideolink((GlobalId)parent.getId(), authorizationContext), authorizationContext.may(parent, VIDEOLINK_LIST_CHECK_ACTIONS));
    }

    @Override
    public Map<VideolinkId, Videolink> getVideolinksByIds(Set<VideolinkId> ids, AuthorizationCheckContextWithLocale authorizationContext) {
        Map<VideolinkId, DBVideolink> dbVideoLinks = this.getDBVideolinksByIds(ids);
        if (dbVideoLinks.isEmpty()) {
            return ImmutableMap.of();
        }
        Iterable parents = Iterables.transform(dbVideoLinks.values(), DBVideolink.GET_PARENT);
        ImmutableSetMultimap parentMays = authorizationContext.mayByIds(parents, VIDEOLINK_LIST_CHECK_ACTIONS);
        Map<VideolinkId, Videolink> result = this.dbToVideolink(dbVideoLinks, authorizationContext);
        for (Videolink videolink : Iterables.filter(result.values(), (Predicate)Predicates.notNull())) {
            videolink.setParentMay((Set<Action>)parentMays.get((Object)Optional.of((Object)videolink.getParentId())));
        }
        return result;
    }

    @Override
    public Videolink getVideolink(VideolinkId id, AuthorizationCheckContextWithLocale authorizationContext) {
        return this.getVideolinksByIds((Set<VideolinkId>)ImmutableSet.of((Object)id), authorizationContext).get(id);
    }

    @Override
    public ListAndCount<Videolink> getVideolinksByParentId(GlobalId parentId, int offset, int limit, AuthorizationCheckContextWithLocale authorizationContext) {
        return this._cacheHelper.getListAndCount(parentId, offset, limit, this._bulkVideolink, authorizationContext);
    }

    @Override
    public ImmutableSetMultimap<GlobalId, VideolinkId> getVideolinkIdsByParentIds(Set<? extends GlobalId> parentIds) {
        return (ImmutableSetMultimap)this._videolinkIdsByParentCacheAccessor.getMultiMap(parentIds);
    }

    @Override
    public int getVideoLinkCount(GlobalId parentId) {
        return ((ImmutableSet)this._videolinkIdsByParentCacheAccessor.getSingle(parentId)).size();
    }

    @Override
    public VideolinkId insertVideolink(DBVideolink videolink, boolean generateFeedMessage, boolean checkOEmbed) throws InvalidIDException {
        GwtOembedVideoData obj;
        if (checkOEmbed && (obj = this.getOEmbed(videolink.getUrl())) != null && !StringUtils.isNotBlank((String)videolink.getTitle())) {
            videolink.setTitle(obj.getTitle());
        }
        VideolinkId newId = this._videolinkDAO.insertVideolink(videolink);
        videolink.setId(newId);
        this._videolinkIdsByParentCacheAccessor.invalidateKey(videolink.getParentId());
        this._eventBus.post(new VideolinkCreatedEvent(videolink, generateFeedMessage));
        return newId;
    }

    @Override
    public void updateTitle(VideolinkId id, String newTitle) {
        this._videolinkDAO.updateTitle(id, newTitle);
        this._cache.delete(VideolinkServiceImpl.videolinkCacheKey(id));
    }

    @Override
    public Videolink getNewestVideolink(GlobalId parentId, AuthorizationCheckContextWithLocale authorizationContext) {
        ImmutableSet videos = (ImmutableSet)this._videolinkIdsByParentCacheAccessor.getSingle(parentId);
        VideolinkId first = (VideolinkId)Iterables.getFirst((Iterable)videos, null);
        if (first == null) {
            return null;
        }
        return this.getVideolink(first, authorizationContext);
    }

    @Override
    public void updateUrl(VideolinkId id, String newUrl, AuthorizationCheckContextWithLocale authorizationContext) {
        authorizationContext.check((ItemId)id, (Action)StaticAction.VIDEOLINK_UPDATE);
        this._videolinkDAO.updateUrl(id, newUrl);
        this._cache.delete(VideolinkServiceImpl.videolinkCacheKey(id));
    }

    @Override
    public void setStorageServerHelper(StorageServerHelper storageServerHelper) {
        this._storageServerHelper = storageServerHelper;
    }

    @VisibleForTesting
    static class OembedInterimResult {
        private final String _videoUrl;
        private final VideoHoster _videoHoster;
        private final String _oEmbedUrlString;
        private final CacheKey _cacheKey;

        public OembedInterimResult(@Nonnull String videoUrl, @Nonnull VideoHoster videoHoster, @Nonnull String oEmbedUrlString, @Nonnull CacheKey cacheKey) {
            this._videoUrl = videoUrl;
            this._videoHoster = videoHoster;
            this._oEmbedUrlString = oEmbedUrlString;
            this._cacheKey = cacheKey;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("videoUrl", (Object)this._videoUrl).add("videoHoster", (Object)this._videoHoster).add("oEmbedUrlString", (Object)this._oEmbedUrlString).add("cacheKey", (Object)this._cacheKey).toString();
        }
    }

    @VisibleForTesting
    static enum VideoLinkServiceCacheName implements CacheName
    {
        VIDEOLINK,
        VIDEOLINK_IDS,
        VIDEOLINK_OEMBED;


        @Override
        public String getCacheName() {
            return this.name();
        }
    }

    public static class JsonOembedVideoData
    implements OembedVideoData {
        private final String _title;
        private final String _thumbnailUrl;
        private final String _html;

        public JsonOembedVideoData(@Nonnull JSONObject obj) throws JSONException {
            this._html = this.extractHtml(obj);
            this._title = this.extractTitle(obj);
            this._thumbnailUrl = this.extractThumbnailUrl(obj);
        }

        @CheckForNull
        private String extractThumbnailUrl(@Nonnull JSONObject obj) {
            try {
                return obj.getString("thumbnail_url");
            }
            catch (JSONException e) {
                return null;
            }
        }

        @CheckForNull
        private String extractTitle(@Nonnull JSONObject obj) {
            try {
                return obj.getString("title");
            }
            catch (JSONException e) {
                return null;
            }
        }

        @Nonnull
        private String extractHtml(@Nonnull JSONObject obj) throws JSONException {
            return (String)Preconditions.checkNotNull((Object)obj.getString("html"));
        }

        @Override
        public String getTitle() {
            return this._title;
        }

        @Override
        public String getThumbnailUrl() {
            return this._thumbnailUrl;
        }

        @Override
        public String getHtml() {
            return this._html;
        }
    }

    private static class DelegatingOembedVideoData
    implements OembedVideoData {
        private final OembedVideoData _delegate;

        protected DelegatingOembedVideoData(@Nonnull OembedVideoData result) {
            this._delegate = result;
        }

        @Override
        public String getTitle() {
            return this._delegate.getTitle();
        }

        @Override
        public String getThumbnailUrl() {
            return this._delegate.getThumbnailUrl();
        }

        @Override
        public String getHtml() {
            return this._delegate.getHtml();
        }
    }
}

