/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.videolink.business.impl;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContextWithLocale;
import de.justsoftware.onx.common.shared.model.action.Action;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.person.shared.model.PersonTeaserModel;
import de.justsoftware.onx.videolink.business.VideolinkCommentedStreamHandler;
import de.justsoftware.onx.videolink.business.VideolinkService;
import de.justsoftware.onx.videolink.shared.model.DBVideolink;
import de.justsoftware.onx.videolink.shared.model.VideolinkId;
import de.justsoftware.onx.workstream.business.AbstractSingleWorkstreamMessageHandler;
import de.justsoftware.onx.workstream.shared.model.DBWorkstreamMessage;
import de.justsoftware.onx.workstream.shared.model.messages.VideolinkCommented;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="videolinkCommentedStreamHandler")
public class VideolinkCommentedStreamHandlerImpl
extends AbstractSingleWorkstreamMessageHandler<VideolinkCommented>
implements VideolinkCommentedStreamHandler {
    @Autowired
    private VideolinkService _videolinkService;

    @Override
    public VideolinkCommented aggregate(VideolinkCommented oldEntry, VideolinkCommented newEntry) {
        if (oldEntry.getVideolinkId().equals(newEntry.getVideolinkId())) {
            return newEntry;
        }
        return null;
    }

    @Override
    public boolean isAggregatePossible() {
        return true;
    }

    @Override
    public ImmutableSetMultimap<String, String> attributesToDelete(Set<? extends ItemId> itemIds) {
        return VideolinkCommentedStreamHandlerImpl.attributesToDelete(itemIds, "video_id", VideolinkId.class);
    }

    @Override
    public VideolinkCommented convert(DBWorkstreamMessage m, PersonTeaserModel author, ImmutableSet<Action> may, AuthorizationCheckContextWithLocale authorizationContext) {
        VideolinkId id = VideolinkId.parse(m.getAttribute("video_id"));
        if (id == null) {
            return null;
        }
        DBVideolink videolink = this._videolinkService.getDBVideolinkById(id);
        if (videolink == null) {
            return null;
        }
        return new VideolinkCommented(m, author, may, id, videolink.getTitle());
    }
}

