/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.videolink.business.impl;

import de.justsoftware.onx.common.business.ServerUrlUtil;
import de.justsoftware.onx.common.business.StorageServerConfig;
import de.justsoftware.onx.videolink.business.VideoConfig;
import de.justsoftware.onx.videolink.shared.model.VideolinkId;
import java.util.regex.Pattern;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class StaticVideoConfig
implements VideoConfig {
    private static final String DEFAULT_THUMBNAIL_STORAGE_PATH = "/images/icon/default-video-thumbnail.png";
    @Autowired
    private ServerUrlUtil _urlUtil;
    @Value(value="${imageServerUrl}")
    private String _imageServerUrl;
    @Autowired
    private StorageServerConfig _storageServerConfig;

    @Override
    public String getVideoStorageBasePath() {
        return "/videos/";
    }

    @Override
    public String getOEmbedTokenPrefix() {
        return "internalvideo.";
    }

    @Override
    public String getOEmbedPlaceholderToken() {
        return this.getOEmbedTokenPrefix() + "JUCOIDPLACEHOLDER";
    }

    @Override
    public VideolinkId extractVideoId(String url) {
        String id = url.replaceFirst("^" + Pattern.quote(this.getOEmbedTokenPrefix()) + "(\\d*)$", "$1");
        return new VideolinkId(Long.parseLong(id));
    }

    @Override
    public String getPublicVideoUrl(String videoFile) {
        return this._imageServerUrl + this.getVideoStorageBasePath() + videoFile;
    }

    @Override
    public String getThumbnailStorageBasePath() {
        return "/videos/thumbnails/";
    }

    @Override
    public String getPublicThumbnailPath(String thumbnailPath, VideolinkId id) {
        return this._urlUtil.getCommonResourcePrefix() + thumbnailPath + "?id=" + id.getId();
    }

    @Override
    public String getInternalThumbnailUrl(String thumbnailFile) {
        return this._storageServerConfig.getUrlWithPath(this.getThumbnailStorageBasePath() + thumbnailFile + ".png");
    }

    @Override
    public Object getThumbnailStoragePath(String newFilename) {
        return this.getThumbnailStorageBasePath() + newFilename + ".png";
    }

    @Override
    public String getDefaultInternalThumbnailUrl() {
        return this._storageServerConfig.getUrlWithPath(DEFAULT_THUMBNAIL_STORAGE_PATH);
    }

    @Override
    public String getDefaultPublicThumbnailUrl() {
        return this._imageServerUrl + DEFAULT_THUMBNAIL_STORAGE_PATH;
    }

    @Override
    public String getPublicPlayerPath(String playerPath, VideolinkId videoId) {
        return this._urlUtil.getCommonResourcePrefix() + playerPath + "?id=" + videoId.getId();
    }

    @Override
    public int getThumbnailWidth() {
        return 64;
    }

    @Override
    public int getThumbnailHeight() {
        return 47;
    }

    @Override
    public int getVideoWidth() {
        return 500;
    }

    @Override
    public int getVideoHeight() {
        return 274;
    }

    @Override
    public String getPlayerView() {
        return "video";
    }
}

