/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.validation.impl;

import com.google.common.base.Function;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContextWithUserId;
import de.justsoftware.onx.util.shared.NullPermeableFunction;
import de.justsoftware.onx.validation.JucoValidationContext;
import de.justsoftware.onx.validation.JucoValidator;
import de.justsoftware.onx.validation.shared.model.JucoConstraintViolation;
import de.justsoftware.onx.validation.shared.model.JucoValidationNode;
import de.justsoftware.onx.validation.shared.model.JucoValidationPath;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Path;
import javax.validation.Validator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class JucoValidatorImpl
implements JucoValidator {
    private static final Function<ConstraintViolation<?>, JucoConstraintViolation> VIOLATION_TRANSFORM = new NullPermeableFunction<ConstraintViolation<?>, JucoConstraintViolation>(){

        @Override
        protected JucoConstraintViolation applySafe(ConstraintViolation<?> input) {
            JucoValidationPath propertyPath;
            Path path = input.getPropertyPath();
            if (path == null) {
                propertyPath = new JucoValidationPath((ImmutableList<JucoValidationNode>)ImmutableList.of());
            } else {
                ImmutableList.Builder nodes = ImmutableList.builder();
                for (Path.Node node : path) {
                    nodes.add((Object)new JucoValidationNode(node.getName(), node.getKey(), node.getIndex(), node.isInIterable()));
                }
                propertyPath = new JucoValidationPath((ImmutableList<JucoValidationNode>)nodes.build());
            }
            return new JucoConstraintViolation(input.getMessage(), propertyPath);
        }
    };
    @Autowired
    @Qualifier(value="validator")
    private Validator _validator;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImmutableSet<JucoConstraintViolation> validate(AuthorizationCheckContextWithUserId authCtx, Object object, Class<?> ... groups) {
        try {
            JucoValidationContext.CURRENT_USER_CONTEXT.set(new JucoValidationContext(authCtx.getLocale()));
            Set violations = this._validator.validate(object, (Class[])groups);
            ImmutableSet immutableSet = FluentIterable.from((Iterable)violations).transform(VIOLATION_TRANSFORM).filter(Predicates.notNull()).toSet();
            return immutableSet;
        }
        finally {
            JucoValidationContext.CURRENT_USER_CONTEXT.remove();
        }
    }
}

