/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.util.server;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestOperations;

@ParametersAreNonnullByDefault
public class RequestBuilder<T> {
    private final Class<T> _responseType;
    private String _url;
    private HttpMethod _httpMethod = HttpMethod.GET;
    private HttpHeaders _headers;
    private Object _postData;
    private final Map<String, String> _parameters = new HashMap<String, String>();

    public RequestBuilder(Class<T> responseType) {
        this._responseType = responseType;
    }

    @Nonnull
    public RequestBuilder<T> url(String url) {
        this._url = url;
        return this;
    }

    @Nonnull
    public RequestBuilder<T> post(@Nullable Object data) {
        this._httpMethod = HttpMethod.POST;
        this._postData = data;
        return this;
    }

    @Nonnull
    public RequestBuilder<T> headers(Map<String, String> headers) {
        this._headers = new HttpHeaders();
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            this._headers.add(entry.getKey(), entry.getValue());
        }
        return this;
    }

    @Nonnull
    public RequestBuilder<T> addParameter(String param, @Nullable String value) {
        this._parameters.put(param, value);
        return this;
    }

    @Nonnull
    public ResponseEntity<T> execute(RestOperations restOperations) throws RestClientException {
        HttpEntity httpEntity = new HttpEntity(this._postData, (MultiValueMap)this._headers);
        return restOperations.exchange(this._url, this._httpMethod, httpEntity, this._responseType, this._parameters);
    }
}

