/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.util.server;

import com.google.common.base.Charsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.annotation.Nonnull;
import org.apache.commons.codec.binary.Hex;

public final class MD5Util {
    private MD5Util() {
    }

    @Nonnull
    private static MessageDigest createDigest() {
        try {
            return MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Die JVM unterst\u00fctzt MD5 nicht!");
        }
    }

    @Nonnull
    public static String getHexHash(@Nonnull String s) {
        return new String(Hex.encodeHex((byte[])MD5Util.getByteHash(s.getBytes(Charsets.ISO_8859_1))));
    }

    @Nonnull
    public static String getHexHash(@Nonnull byte[] b) {
        return new String(Hex.encodeHex((byte[])MD5Util.getByteHash(b)));
    }

    @Nonnull
    public static byte[] getUtf8ByteHash(@Nonnull String s) {
        return MD5Util.getByteHash(s.getBytes(Charsets.UTF_8));
    }

    @Nonnull
    public static byte[] getByteHash(@Nonnull byte[] b) {
        return MD5Util.createDigest().digest(b);
    }
}

