/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.util.server;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;

public class LogTimer {
    protected final Logger _logger;
    protected Long _totalDuration = null;
    protected final String _name;
    private final Map<String, Long> _stops = new HashMap<String, Long>();
    private final long _start;

    protected LogTimer(String name, Logger logger) {
        this._name = name;
        this._logger = logger;
        this._start = System.currentTimeMillis();
    }

    public static LogTimer getTimer(String name, Logger logger) {
        if (!logger.isDebugEnabled()) {
            return SilentTimer.INSTANCE;
        }
        return new LogTimer(name, logger);
    }

    public static LogTimer getTimer(String name, Logger logger, int maxMillis) {
        return new LogTimerWithThreshold(name, logger, maxMillis);
    }

    public void makeStop(String stopName) {
        if (StringUtils.isEmpty((String)stopName)) {
            return;
        }
        this._stops.put(stopName, System.currentTimeMillis() - this._start);
    }

    public void finish() {
        if (this._totalDuration != null) {
            throw new IllegalArgumentException("Timer already finished. Must not be called twice");
        }
        long currentTimeMillis = System.currentTimeMillis();
        this._totalDuration = currentTimeMillis - this._start;
        if (this._logger.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder();
            if (!this._stops.isEmpty()) {
                sb.append("Stops: ");
                sb.append(this._stops.toString());
            }
            sb.append("Timer " + this._name + " took " + this._totalDuration + " in total.");
            this._logger.debug(sb.toString());
        }
    }

    private static final class SilentTimer
    extends LogTimer {
        static final SilentTimer INSTANCE = new SilentTimer();

        private SilentTimer() {
            super(null, null);
        }

        @Override
        public void makeStop(String stopName) {
        }

        @Override
        public void finish() {
        }
    }

    private static final class LogTimerWithThreshold
    extends LogTimer {
        private final Integer _maxMillis;

        private LogTimerWithThreshold(String name, Logger logger, Integer maxMillis) {
            super(name, logger);
            this._maxMillis = maxMillis;
        }

        @Override
        public void finish() {
            super.finish();
            if (this._totalDuration > (long)this._maxMillis.intValue()) {
                this._logger.error("LogTimer: " + this._name + " took longer than " + this._maxMillis + " ms!");
            }
        }
    }
}

