/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.util.server;

import de.justsoftware.onx.secret.business.HMacSecretKey;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.lang.ArrayUtils;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.crypto.digests.SHA512Digest;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.params.KeyParameter;

@ParametersAreNonnullByDefault
public final class HMacUtil {
    public static final int HMAC_SHA1_BYTE_LENGTH = 20;
    public static final int HMAC_SHA512_BYTE_LENGTH = 64;

    private HMacUtil() {
    }

    @Nonnull
    private static byte[] createHMac(HMac hmac, byte[] toHash, HMacSecretKey secret) {
        byte[] computedHMac = new byte[hmac.getMacSize()];
        hmac.init((CipherParameters)new KeyParameter(secret.asByteArray()));
        hmac.update(toHash, 0, toHash.length);
        hmac.doFinal(computedHMac, 0);
        return computedHMac;
    }

    @Nonnull
    public static byte[] computeHMac(HMacType hmacType, byte[] data, HMacSecretKey secret) {
        return HMacUtil.createHMac(hmacType._hmac, data, secret);
    }

    @Nonnull
    public static byte[] computeHMac(byte[] data, HMacSecretKey secret) {
        return HMacUtil.computeHMac(HMacType.HMAC_SHA1, data, secret);
    }

    @Nonnull
    public static byte[] appendHMac(byte[] toHash, HMacSecretKey secret) {
        return ArrayUtils.addAll((byte[])toHash, (byte[])HMacUtil.computeHMac(toHash, secret));
    }

    @ParametersAreNonnullByDefault
    public static enum HMacType {
        HMAC_SHA1(new HMac((Digest)new SHA1Digest())),
        HMAC_SHA512(new HMac((Digest)new SHA512Digest()));

        final HMac _hmac;

        private HMacType(HMac hmac) {
            this._hmac = hmac;
        }
    }
}

