/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.util.server;

import com.google.common.base.Charsets;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EncodingUtil {
    private static final Logger LOG = LoggerFactory.getLogger(EncodingUtil.class);

    private EncodingUtil() {
    }

    @Nonnull
    public static String encodeURL(@Nonnull String toEncode) {
        try {
            return URLEncoder.encode(toEncode, Charsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            LOG.error("Unexpected error while encoding url", (Throwable)e);
            return toEncode;
        }
    }

    @Nonnull
    public static String decodeURI(@Nonnull String s) {
        try {
            return URLDecoder.decode(s.replaceAll("\\+", "%2B"), Charsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            LOG.error("Unexpected error while encoding url", (Throwable)e);
            return s;
        }
    }

    @Nonnull
    public static String encodeURI(@Nonnull String s) {
        try {
            return URLEncoder.encode(s, Charsets.UTF_8.name()).replaceAll("\\+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            LOG.error("Unexpected error while encoding url", (Throwable)e);
            return s;
        }
    }
}

