/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.util.server;

import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class CSVParser {
    private static final Function<String, List<String>> SPLIT_FUNCTION = new Function<String, List<String>>(){

        public List<String> apply(String input) {
            if (input == null) {
                return null;
            }
            List<String> list = Arrays.asList(input.split("\\s*;\\s*"));
            if (list.size() == 1 && list.get(0).isEmpty()) {
                return Collections.emptyList();
            }
            return list;
        }
    };
    private static final Function<String, String> UNQUOTE_FUNCTION = new Function<String, String>(){

        public String apply(String input) {
            if (input == null) {
                return null;
            }
            if (!input.startsWith("\"") || !input.endsWith("\"")) {
                throw new IllegalArgumentException("Field not properly quoted: " + input);
            }
            String unwrap = input.substring(1, input.length() - 1);
            return unwrap.replaceAll("\\\\\"", "\"");
        }
    };

    public static Iterator<CSVLine> read(InputStream input) {
        return new CSVLineIterator(input);
    }

    public static Iterable<CSVLine> read(String input) {
        return new CSVIterable(input);
    }

    static class CSVLineImpl
    implements CSVLine {
        private final int _line;
        private final List<String> _fields;

        public CSVLineImpl(int line, List<String> fields) {
            this._line = line;
            this._fields = fields;
        }

        @Override
        public int getLineNumber() {
            return this._line;
        }

        @Override
        public List<String> fields() {
            return this._fields;
        }

        public String toString() {
            return this._line + ":" + this._fields;
        }

        @Override
        public boolean isEmpty() {
            return this._fields == null || Iterables.all(this._fields, s -> s == null || s.isEmpty());
        }
    }

    static class CSVLineIterator
    implements Iterator<CSVLine> {
        private final BufferedReader _bufferedReader;
        private int _nextLineNr = 1;
        private boolean _eof = false;
        private String _nextLine;

        CSVLineIterator(Reader input) {
            this._bufferedReader = new BufferedReader(input);
        }

        CSVLineIterator(InputStream input) {
            this._bufferedReader = new BufferedReader(new InputStreamReader(input, Charsets.UTF_8));
        }

        private String getNextLine() {
            if (!this._eof && this._nextLine == null) {
                try {
                    this._nextLine = this._bufferedReader.readLine();
                    if (this._nextLine == null) {
                        this._eof = true;
                    }
                }
                catch (IOException e) {
                    this._eof = true;
                    return null;
                }
            }
            return this._nextLine;
        }

        @Override
        public boolean hasNext() {
            return this.getNextLine() != null;
        }

        @Override
        public CSVLine next() {
            String currentLine = this._nextLine;
            this._nextLine = null;
            int currentLineNr = this._nextLineNr++;
            List fields = (List)SPLIT_FUNCTION.apply((Object)currentLine.trim());
            List strippedFields = Lists.transform((List)fields, UNQUOTE_FUNCTION);
            return new CSVLineImpl(currentLineNr, strippedFields);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("read only");
        }
    }

    static class CSVIterable
    implements Iterable<CSVLine> {
        private final String _input;

        CSVIterable(String input) {
            this._input = input;
        }

        @Override
        public Iterator<CSVLine> iterator() {
            return new CSVLineIterator(new StringReader(this._input));
        }
    }

    public static interface CSVLine {
        public int getLineNumber();

        public List<String> fields();

        public boolean isEmpty();
    }
}

