/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.usergroup.integration.persistence.ibatis;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import de.justsoftware.onx.common.integration.persistence.StatementBuilderFactory;
import de.justsoftware.onx.common.integration.persistence.ibatis.IbatisPartitionResultBuilder;
import de.justsoftware.onx.common.integration.persistence.ibatis.IbatisStandardResultBuilder;
import de.justsoftware.onx.common.integration.persistence.ibatis.IbatisStatementBuilder;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.container.shared.model.TenantId;
import de.justsoftware.onx.usergroup.model.UserGroup;
import de.justsoftware.onx.usergroup.model.UserGroupId;
import java.util.HashMap;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class IbatisUserGroupDAO {
    private static final String PARAM_GROUP_ID = "groupId";
    private static final String PARAM_PERSON_ID = "personId";
    private static final String PARAM_CREATED_AT = "createdAt";
    private static final String PARAM_MODIFIED_AT = "modifiedAt";
    private final IbatisStatementBuilder _ibatisStatementBuilder;

    @Autowired
    public IbatisUserGroupDAO(StatementBuilderFactory statementBuilderFactory) {
        this._ibatisStatementBuilder = statementBuilderFactory.ibatistStatementBuilder("UserGroup");
    }

    @Nonnull
    public ImmutableMap<UserGroupId, UserGroup> getUserGroupsByIds(ImmutableSet<UserGroupId> userGroupIds) {
        return ((IbatisPartitionResultBuilder)this._ibatisStatementBuilder.select("selectUserGroupsByIds").partition(userGroupIds)).asMap(UserGroup::getGroupId);
    }

    public void upsertUserGroup(UserGroup group) {
        this._ibatisStatementBuilder.updateDbSpecific("insertUserGroup").param(group);
    }

    public void deleteUserGroup(UserGroupId groupId) {
        this._ibatisStatementBuilder.delete("deleteUserGroup").param(PARAM_GROUP_ID, groupId.getId());
    }

    @Nonnull
    public ImmutableList<PersonId> selectUserGroupMembers(UserGroupId groupId) {
        return ((IbatisStandardResultBuilder)this._ibatisStatementBuilder.select("selectUserGroupMembers").param(PARAM_GROUP_ID, groupId.getId())).asList();
    }

    public void upsertUserGroupMembership(UserGroupId groupId, PersonId personId) {
        this._ibatisStatementBuilder.updateDbSpecific("insertUserGroupMembership").param(PARAM_GROUP_ID, groupId.getId(), PARAM_PERSON_ID, personId.getId());
    }

    public void deleteUserGroupMembership(UserGroupId groupId, PersonId personId) {
        this._ibatisStatementBuilder.delete("deleteUserGroupMembership").param(PARAM_GROUP_ID, groupId.getId(), PARAM_PERSON_ID, personId.getId());
    }

    @Nonnull
    public ImmutableSetMultimap<UserGroupId, PersonId> getUserGroupMembersByIds(ImmutableSet<UserGroupId> userGroupIds) {
        return ((IbatisPartitionResultBuilder)this._ibatisStatementBuilder.select("getPersonIdsByGroupIds").partition(userGroupIds)).asSetMultimap(PARAM_GROUP_ID, PARAM_PERSON_ID);
    }

    @CheckForNull
    public UserGroup getAllUsersGroup(TenantId tenantId) {
        return (UserGroup)this._ibatisStatementBuilder.select("getAllUsersGroup").param(tenantId).singleObject();
    }

    public void updateUserGroupModifiedAt(UserGroupId groupId) {
        this.updateUserGroupModifiedAt(groupId, null);
    }

    @VisibleForTesting
    public void updateUserGroupModifiedAt(UserGroupId groupId, @Nullable DateTime modifiedAt) {
        HashMap<String, UserGroupId> params = new HashMap<String, UserGroupId>();
        params.put(PARAM_GROUP_ID, groupId);
        params.put(PARAM_MODIFIED_AT, (UserGroupId)modifiedAt);
        this._ibatisStatementBuilder.update("updateUserGroupModifiedAt").param(params);
    }

    @VisibleForTesting
    public void updateUserGroupMembershipCreatedAt(UserGroupId groupId, PersonId personId, DateTime createdAt) {
        this._ibatisStatementBuilder.update("updateUserGroupMembershipCreatedAt").param(PARAM_GROUP_ID, groupId, PARAM_PERSON_ID, personId, PARAM_CREATED_AT, createdAt);
    }
}

