/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.usergroup.business.impl.kafka;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Table;
import de.justsoftware.onx.common.business.events.JCEventBus;
import de.justsoftware.onx.common.business.events.util.CollectingServerEventCollector;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.model.ProfileId;
import de.justsoftware.onx.common.shared.server.TransactionHelper;
import de.justsoftware.onx.container.shared.model.IdParseException;
import de.justsoftware.onx.kafka.AbstractKafkaConsumer;
import de.justsoftware.onx.kafka.KafkaConfigurationProvider;
import de.justsoftware.onx.kafka.KafkaConsumerContext;
import de.justsoftware.onx.usergroup.business.impl.UserGroupService;
import de.justsoftware.onx.usergroup.model.UserGroupId;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
@Lazy(value=false)
@ParametersAreNonnullByDefault
public class UserGroupMemberKafkaConsumer
extends AbstractKafkaConsumer<String, String> {
    private static final Logger LOG = LoggerFactory.getLogger(UserGroupMemberKafkaConsumer.class);
    private final UserGroupService _userGroupService;
    private final JCEventBus _eventBus;

    @Autowired
    public UserGroupMemberKafkaConsumer(TransactionHelper transactionHelper, KafkaConfigurationProvider kafkaConfigurationProvider, UserGroupService userGroupService, JCEventBus eventBus) {
        this(kafkaConfigurationProvider.consumer("just.onx.message.userGroupMemberConsumer", new StringDeserializer(), new StringDeserializer()), transactionHelper, userGroupService, eventBus);
    }

    @VisibleForTesting
    UserGroupMemberKafkaConsumer(@Nullable Consumer<String, String> consumer, TransactionHelper transactionHelper, UserGroupService userGroupService, JCEventBus eventBus) {
        super(consumer, transactionHelper, "just.people.userGroupMembers");
        this._userGroupService = userGroupService;
        this._eventBus = eventBus;
    }

    @Override
    @Nonnull
    protected Logger getLog() {
        return LOG;
    }

    @Override
    public void process(ConsumerRecords<String, String> records, KafkaConsumerContext context) {
        CollectingServerEventCollector eventCollector = new CollectingServerEventCollector();
        HashBasedTable userGroupMemberships = HashBasedTable.create();
        records.forEach(arg_0 -> UserGroupMemberKafkaConsumer.lambda$process$0((Table)userGroupMemberships, arg_0));
        ImmutableSetMultimap.Builder membersToAdd = ImmutableSetMultimap.builder();
        ImmutableSetMultimap.Builder membersToRemove = ImmutableSetMultimap.builder();
        userGroupMemberships.cellSet().forEach(cell -> {
            UserGroupId userGroupId = (UserGroupId)cell.getRowKey();
            PersonId personId = (PersonId)cell.getColumnKey();
            if (userGroupId != null && personId != null) {
                if (cell.getValue() != null && ((Boolean)cell.getValue()).booleanValue()) {
                    membersToAdd.put((Object)userGroupId, (Object)personId);
                } else {
                    membersToRemove.put((Object)userGroupId, (Object)personId);
                }
            }
        });
        this._userGroupService.addUserGroupMemberships((ImmutableSetMultimap<UserGroupId, PersonId>)membersToAdd.build(), eventCollector);
        this._userGroupService.removeUserGroupMemberships((ImmutableSetMultimap<UserGroupId, PersonId>)membersToRemove.build(), eventCollector);
        context.afterCommit(() -> eventCollector.fireEvents(this._eventBus));
    }

    private static /* synthetic */ void lambda$process$0(Table userGroupMemberships, ConsumerRecord record) {
        try {
            String key = (String)record.key();
            int indexOfAt = key.indexOf(64);
            if (indexOfAt == -1) {
                LOG.warn(String.format("Unable to parse record key '%s'. This might be okay as the key format has been changed. Skip this record.", key));
                return;
            }
            Optional<UserGroupId> groupId = UserGroupId.parse(key.substring(0, indexOfAt));
            ProfileId profileId = ProfileId.parse(key.substring(indexOfAt + 1));
            if (profileId == null || groupId.isEmpty()) {
                throw new IdParseException(String.format("Unable to parse record key '%s'", key));
            }
            PersonId personId = profileId.asPersonId();
            userGroupMemberships.put((Object)groupId.get(), (Object)personId, (Object)(record.value() != null && Boolean.parseBoolean((String)record.value()) ? 1 : 0));
        }
        catch (IdParseException exp) {
            LOG.error(String.format("Failed to update user group membership with key '%s' and value '%s'. Skip this record.", record.key(), record.value()), (Throwable)exp);
        }
    }
}

