/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.usergroup.business.impl.kafka;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import de.justsoftware.onx.container.shared.model.TenantId;
import de.justsoftware.onx.usergroup.model.UserGroup;
import de.justsoftware.onx.usergroup.model.UserGroupId;
import java.io.IOException;
import java.util.Map;
import org.apache.kafka.common.serialization.Deserializer;

public class UserGroupDeserializer
implements Deserializer<UserGroup> {
    private static final ObjectMapper JSON_MAPPER = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);

    public void configure(Map<String, ?> configs, boolean isKey) {
    }

    public UserGroup deserialize(String topic, byte[] data) {
        if (data == null) {
            return null;
        }
        try {
            return (UserGroup)JSON_MAPPER.readValue(data, UserGroup.class);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed to deserialize data to user group", e);
        }
    }

    public void close() {
    }

    static {
        SimpleModule module = new SimpleModule();
        module.addDeserializer(TenantId.class, (JsonDeserializer)new JsonDeserializer<TenantId>(){

            public TenantId deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
                return TenantId.parse(p.getValueAsString()).orElseThrow();
            }
        });
        module.addDeserializer(UserGroupId.class, (JsonDeserializer)new JsonDeserializer<UserGroupId>(){

            public UserGroupId deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
                return UserGroupId.parse(p.getValueAsString()).orElseThrow();
            }
        });
        JSON_MAPPER.registerModule((Module)module);
    }
}

