/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.thumbor.util;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class ThumborURLBuilder {
    private static final String URI_ENCODING = "UTF-8";
    private static final String DOCKER_HOST = "dockerhost";
    private static final ImmutableSet<String> LOCALHOST_NAMES = ImmutableSet.of((Object)"localhost", (Object)"127.0.0.1");
    private final String _thumborHostname;
    private final int _port;
    private final URL _imageURL;
    private int _width = 0;
    private int _height = 0;
    private boolean _trim = false;
    private boolean _smart = false;
    private boolean _flipHorizontally = false;
    private boolean _flipVertically = false;
    private boolean _fitIn = false;
    private final SortedMap<String, ImmutableList<String>> _filtersAndParams = new TreeMap<String, ImmutableList<String>>();

    public ThumborURLBuilder(String thumborHostname, int port, URL imageUrl) {
        this._thumborHostname = thumborHostname;
        this._port = port;
        this._imageURL = ThumborURLBuilder.rewriteLocalhostToDockerHostIP(imageUrl);
    }

    @Nonnull
    private static URL rewriteLocalhostToDockerHostIP(URL url) {
        if (LOCALHOST_NAMES.contains((Object)url.getHost().toLowerCase())) {
            try {
                return new URL(url.getProtocol(), DOCKER_HOST, url.getPort(), url.getFile());
            }
            catch (MalformedURLException e) {
                throw new IllegalStateException("Unexpected error while rewriting URL host from localhost to docker host IP: " + e.getMessage(), e);
            }
        }
        return url;
    }

    @Nonnull
    public ThumborURLBuilder withWidth(int width) {
        if (width < 0) {
            throw new IllegalArgumentException("Width has to be >= 0");
        }
        this._width = width;
        return this;
    }

    @Nonnull
    public ThumborURLBuilder withHeight(int height) {
        if (height < 0) {
            throw new IllegalArgumentException("Height has to be >= 0");
        }
        this._height = height;
        return this;
    }

    @Nonnull
    public ThumborURLBuilder withTrim(boolean trim) {
        this._trim = trim;
        return this;
    }

    @Nonnull
    public ThumborURLBuilder withSmart(boolean smart) {
        this._smart = smart;
        return this;
    }

    @Nonnull
    public ThumborURLBuilder withFitIn(boolean fitIn) {
        this._fitIn = fitIn;
        return this;
    }

    @Nonnull
    public ThumborURLBuilder withFlipHorizontally(boolean flipHorizontally) {
        this._flipHorizontally = flipHorizontally;
        return this;
    }

    @Nonnull
    public ThumborURLBuilder withFlipVertically(boolean flipVertically) {
        this._flipVertically = flipVertically;
        return this;
    }

    @Nonnull
    public ThumborURLBuilder withExtractCoverFilter() {
        this.addFilter("extract_cover", new String[0]);
        return this;
    }

    @Nonnull
    public ThumborURLBuilder withGrayscaleFilter() {
        this.addFilter("grayscale", new String[0]);
        return this;
    }

    @Nonnull
    public ThumborURLBuilder withBlurFilter(int radius) {
        if (radius > 150) {
            throw new IllegalArgumentException("Radius of blur filter has to be <= 150");
        }
        this.addFilter("blur", String.valueOf(radius));
        return this;
    }

    @Nonnull
    public ThumborURLBuilder withQualityFilter(int amount) {
        if (amount < 0 || amount > 100) {
            throw new IllegalArgumentException("Amount of quality filter has to be between 0 and 100");
        }
        this.addFilter("quality", String.valueOf(amount));
        return this;
    }

    private void addFilter(String filtername, String ... filterParams) {
        this._filtersAndParams.put(filtername, (ImmutableList<String>)ImmutableList.copyOf((Object[])filterParams));
    }

    private void conditionalAppend(StringBuilder destination, boolean condition, String value) {
        if (condition) {
            destination.append(value);
        }
    }

    @Nonnull
    private static String encodeUrl(String url) {
        try {
            return URLEncoder.encode(url, URI_ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("UTF-8 encoding is not supported", e);
        }
    }

    private void appendFilters(StringBuilder destination) {
        boolean hasFilters;
        boolean bl = hasFilters = this._filtersAndParams.size() > 0;
        if (hasFilters) {
            destination.append("filters");
        }
        for (Map.Entry<String, ImmutableList<String>> filterAndParems : this._filtersAndParams.entrySet()) {
            destination.append(":").append(ThumborURLBuilder.encodeUrl(filterAndParems.getKey())).append("(").append(Joiner.on((String)",").join((Iterable)filterAndParems.getValue().stream().map(ThumborURLBuilder::encodeUrl).collect(Collectors.toList()))).append(")");
        }
        if (hasFilters) {
            destination.append("/");
        }
    }

    @Nonnull
    public String build() {
        StringBuilder builder = new StringBuilder("http://").append(this._thumborHostname).append(":").append(this._port).append("/");
        this.conditionalAppend(builder, this._trim, "trim/");
        this.conditionalAppend(builder, this._fitIn, "fit-in/");
        this.conditionalAppend(builder, this._flipHorizontally, "-");
        builder.append(this._width).append("x");
        this.conditionalAppend(builder, this._flipVertically, "-");
        builder.append(this._height).append("/");
        this.conditionalAppend(builder, this._smart, "smart/");
        this.appendFilters(builder);
        builder.append(this._imageURL.toString());
        return builder.toString();
    }
}

