/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.thumbor.business.impl;

import com.freiheit.toro.common.shared.model.ServiceException;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.thumbor.business.ThumborService;
import de.justsoftware.onx.thumbor.util.ThumborURLBuilder;
import de.justsoftware.onx.util.server.RequestBuilder;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestOperations;

@Service
@ParametersAreNonnullByDefault
public class ThumborServiceImpl
implements ThumborService {
    private static final Logger LOG = LoggerFactory.getLogger(ThumborServiceImpl.class);
    private static final long MIN_HEALTHCHECK_DELAY_SECONDS = 5L;
    private static final long MAX_HEALTHCHECK_DELAY_SECONDS = 300L;
    private static final String GIF_CONTENT_TYPE = "image/gif";
    private static final ImmutableSet<String> SUPPORTED_IMAGE_TYPES = ImmutableSet.of((Object)"image/bmp", (Object)"image/gif", (Object)"image/jpeg", (Object)"image/png", (Object)"image/x-png", (Object)"image/tiff", (Object[])new String[]{"image/webp"});
    private final String _thumborHostname;
    private final int _thumborPort;
    private final RestOperations _restOperations;
    private final String _thumborHealthUrl;
    private final ScheduledExecutorService _healthCheckExecutorService = Executors.newScheduledThreadPool(1);
    private volatile boolean _thumborIsAvailable = false;

    @Autowired
    public ThumborServiceImpl(@Value(value="${just-thumbor.host:localhost}") String thumborHostname, @Value(value="${just-thumbor.port:8888}") int thumborPort, @Qualifier(value="defaultRestTemplate") RestOperations restOperations) {
        this._thumborHostname = thumborHostname;
        this._thumborPort = thumborPort;
        this._restOperations = restOperations;
        this._thumborHealthUrl = MessageFormat.format("http://{0}:{1}/healthcheck", this._thumborHostname, String.valueOf(this._thumborPort));
    }

    @Override
    public String getThumbnailUrl(String imageURL, String contentType, int width, int height) throws MalformedURLException {
        if (!this.thumbnailAvailable(contentType) || !this.isThumborAvailable()) {
            return null;
        }
        ThumborURLBuilder urlBuilder = this.createThumborURLBuilder(new URL(imageURL)).withWidth(width).withHeight(height);
        return this.isGifImage(contentType) ? urlBuilder.withExtractCoverFilter().build() : urlBuilder.withSmart(true).build();
    }

    @Override
    public String getPngForSvgUrl(String svgUrl, int width, int height) throws MalformedURLException {
        if (!this.isThumborAvailable()) {
            return null;
        }
        return this.createThumborURLBuilder(new URL(svgUrl)).withWidth(width).withHeight(height).withFitIn(true).build();
    }

    @Override
    public boolean thumbnailAvailable(String contentType) {
        String contentTypeNormalized = this.normalizeContentType(contentType);
        boolean isImage = contentTypeNormalized.startsWith("image/");
        boolean isVideo = contentTypeNormalized.startsWith("video/");
        return isVideo || isImage && SUPPORTED_IMAGE_TYPES.contains((Object)contentTypeNormalized);
    }

    @Override
    public ImmutableSet<String> supportedImageTypes() {
        return SUPPORTED_IMAGE_TYPES;
    }

    @Nonnull
    private ThumborURLBuilder createThumborURLBuilder(URL imageURL) {
        return new ThumborURLBuilder(this._thumborHostname, this._thumborPort, imageURL);
    }

    private boolean isGifImage(String contentType) {
        return Objects.equals(this.normalizeContentType(contentType), GIF_CONTENT_TYPE);
    }

    private boolean isThumborAvailable() {
        return this._thumborIsAvailable;
    }

    @Nonnull
    private String normalizeContentType(String contentType) {
        int semi = contentType.indexOf(";");
        return semi > 0 ? contentType.substring(0, semi).toLowerCase() : contentType.toLowerCase();
    }

    @Override
    public void checkHealth() {
        try {
            ResponseEntity<String> response = new RequestBuilder<String>(String.class).url(this._thumborHealthUrl).execute(this._restOperations);
            HttpStatus statusCode = response.getStatusCode();
            if (statusCode != HttpStatus.OK) {
                throw new ServiceException("Healthcheck request returned status: " + statusCode.value() + " (" + statusCode.getReasonPhrase() + ")");
            }
            String result = (String)response.getBody();
            if (!"WORKING".equals(result)) {
                throw new ServiceException("Unexpected result of health check request: " + result);
            }
            this._thumborIsAvailable = true;
        }
        catch (RuntimeException e) {
            this._thumborIsAvailable = false;
            throw e;
        }
    }

    @PostConstruct
    public void startPeriodicHealthCheck() {
        this.updateHealthStatusAndReschedule(5L);
    }

    @PreDestroy
    public void stopPeriodicHealthCheck() throws InterruptedException {
        LOG.info("Thumbor health check shutting down ...");
        this._healthCheckExecutorService.shutdownNow();
        this._healthCheckExecutorService.awaitTermination(5L, TimeUnit.SECONDS);
        LOG.info("Thumbor health check successfully shut down.");
    }

    private void updateHealthStatusAndReschedule(long lastDelay) {
        boolean wasAvailable = this._thumborIsAvailable;
        this.updateHealthStatus();
        if (this._thumborIsAvailable) {
            LOG.debug("Thumbor health check: Thumbor is available.");
        } else {
            LOG.info("Thumbor health check: Thumbor is not available.");
        }
        long delay = !this._thumborIsAvailable ? (wasAvailable ? 5L : Math.min(lastDelay * 2L, 300L)) : 300L;
        this._healthCheckExecutorService.schedule(() -> this.updateHealthStatusAndReschedule(delay), delay, TimeUnit.SECONDS);
    }

    private void updateHealthStatus() {
        try {
            this.checkHealth();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }
}

