/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.tenantinvitation.persistence;

import de.justsoftware.onx.container.shared.model.TenantId;
import de.justsoftware.onx.tenantinvitation.model.TenantInvitation;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.ibatis.annotations.Arg;
import org.apache.ibatis.annotations.ConstructorArgs;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.ResultType;
import org.apache.ibatis.annotations.Select;

@Mapper
@ParametersAreNonnullByDefault
public interface TenantInvitationMapper {
    @ConstructorArgs(value={@Arg(javaType=TenantId.class, column="tenant_id", id=true), @Arg(javaType=String.class, column="tenant_invitation_code")})
    @Select(value={"SELECT tenant_id, tenant_invitation_code FROM tenant_invitation WHERE tenant_invitation_code=#{tenantInvitationCode}"})
    @ResultType(value=TenantInvitation.class)
    @CheckForNull
    public Set<TenantInvitation> getTenantInvitationCode(@Param(value="tenantInvitationCode") String var1);

    @Insert(value={"<script>", "<if test=\"_databaseId == 'POSTGRES'\">", "INSERT INTO tenant_invitation (tenant_id, tenant_invitation_code) VALUES( #{tenantId}, #{tenantInvitationCode} ) ", "ON CONFLICT(tenant_id, tenant_invitation_code) DO NOTHING", "</if>", "<if test=\"_databaseId == 'ORACLE'\">", "MERGE INTO tenant_invitation t ", "USING (SELECT #{tenantId} as tenantId, #{tenantInvitationCode} as tenantInvitationCode from dual) s ON (s.tenantId = t.tenant_id AND s.tenantInvitationCode = t.tenant_invitation_code)WHEN NOT MATCHED THEN INSERT (tenant_id, tenant_invitation_code) VALUES( #{tenantId}, #{tenantInvitationCode})", "</if>", "</script>"})
    public void upsertTenantInviteCode(@Param(value="tenantId") TenantId var1, @Param(value="tenantInvitationCode") String var2);

    @Delete(value={"DELETE FROM tenant_invitation WHERE tenant_id = #{tenantId}"})
    public void deleteTenantInvitation(TenantId var1);
}

