/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.tenantinvitation.business.impl;

import com.freiheit.toro.common.shared.model.PermissionDeniedException;
import de.justsoftware.onx.container.shared.model.TenantId;
import de.justsoftware.onx.tenantinvitation.model.TenantInvitation;
import de.justsoftware.onx.tenantinvitation.persistence.TenantInvitationDao;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.springframework.stereotype.Service;

@Service
public class TenantInvitationService {
    private final TenantInvitationDao _tenantInvitationDAO;

    public TenantInvitationService(TenantInvitationDao tenantInvitationDAO) {
        this._tenantInvitationDAO = tenantInvitationDAO;
    }

    public TenantInvitation checkTenantInvitationCode(String tenantInvitationCode) {
        return this.getOptionalTenantInvitation(tenantInvitationCode).orElseThrow(PermissionDeniedException::new);
    }

    private Optional<TenantInvitation> getOptionalTenantInvitation(String tenantInvitationCode) {
        Set<TenantInvitation> tenantInvitationCodes = this._tenantInvitationDAO.getTenantInvitationCode(tenantInvitationCode);
        return tenantInvitationCodes.stream().filter(tenantInvite -> tenantInvite.getTenantInvitationCode().equals(tenantInvitationCode)).findFirst();
    }

    public void setTenantInvitationCode(@Nullable String invitationCode, TenantId tenantId) {
        if (invitationCode == null) {
            this.deleteTenantInvitation(tenantId);
        } else {
            this.upsertTenantInvitationCode(tenantId, invitationCode);
        }
    }

    public void upsertTenantInvitationCode(TenantId tenantId, String tenantInvitationCode) {
        this._tenantInvitationDAO.upsertTenantInvitation(tenantId, tenantInvitationCode);
    }

    public void deleteTenantInvitation(TenantId tenantId) {
        this._tenantInvitationDAO.deleteTenantInvitation(tenantId);
    }
}

