/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.tenantdesign.persistence;

import de.justsoftware.onx.container.shared.model.TenantId;
import de.justsoftware.onx.tenantdesign.model.TenantThemeAttribute;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.ibatis.annotations.Arg;
import org.apache.ibatis.annotations.ConstructorArgs;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.ResultType;
import org.apache.ibatis.annotations.Select;

@Mapper
@ParametersAreNonnullByDefault
public interface TenantThemeMapper {
    @ConstructorArgs(value={@Arg(javaType=TenantId.class, column="tenant_id", id=true), @Arg(javaType=String.class, column="theme_attribute"), @Arg(javaType=String.class, column="theme_value")})
    @Select(value={"<script>", "SELECT tenant_id, theme_attribute, theme_value FROM tenant_theme WHERE tenant_id=#{tenantId}", "</script>"})
    @ResultType(value=TenantThemeAttribute.class)
    public List<TenantThemeAttribute> getTenantThemeAttributes(@Param(value="tenantId") TenantId var1);

    @Insert(value={"<script>", "<if test=\"_databaseId == 'POSTGRES'\">", "INSERT INTO tenant_theme (tenant_id, theme_attribute, theme_value) VALUES( #{tenantId}, #{themeAttribute}, #{themeValue} ) ", "ON CONFLICT(tenant_id, theme_attribute) DO UPDATE SET theme_value = #{themeValue}", "</if>", "<if test=\"_databaseId == 'ORACLE'\">", "MERGE INTO tenant_theme a ", "USING (SELECT #{tenantId} as tenantId, #{themeAttribute} as theme_attribute from dual) s ON (s.tenantId = a.tenant_id AND s.theme_attribute = a.theme_attribute)WHEN MATCHED THEN UPDATE SET theme_value = #{themeValue}WHEN NOT MATCHED THEN INSERT (tenant_id, theme_attribute, theme_value) VALUES( #{tenantId}, #{themeAttribute}, #{themeValue})", "</if>", "</script>"})
    public void upsertTenantThemeAttribute(@Param(value="tenantId") TenantId var1, @Param(value="themeAttribute") String var2, @Param(value="themeValue") String var3);
}

