/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.tenantdesign;

import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.appswitcher.shared.model.CoreApp;
import de.justsoftware.onx.container.shared.model.TenantId;
import de.justsoftware.onx.design.shared.model.ThemeAttribute;
import de.justsoftware.onx.design.shared.model.ThemeAttributeType;
import de.justsoftware.onx.design.shared.model.ThemeId;
import de.justsoftware.onx.tenant.business.TenantService;
import de.justsoftware.onx.tenant.integration.persistence.model.Tenant;
import de.justsoftware.onx.tenantdesign.model.TenantThemeAttribute;
import de.justsoftware.onx.tenantdesign.model.Theme;
import de.justsoftware.onx.tenantdesign.persistence.TenantThemeDao;
import java.util.HashMap;
import java.util.List;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class ThemeService {
    private final TenantService _tenantService;
    private final TenantThemeDao _tenantThemeDao;
    private final de.justsoftware.onx.design.business.ThemeService _legacyThemeService;

    @Autowired
    public ThemeService(TenantService tenantService, TenantThemeDao tenantThemeDao, de.justsoftware.onx.design.business.ThemeService legacyThemeService) {
        this._tenantService = tenantService;
        this._tenantThemeDao = tenantThemeDao;
        this._legacyThemeService = legacyThemeService;
    }

    @Nonnull
    public Theme getTheme(TenantId tenantId) {
        List<TenantThemeAttribute> tenantThemeAttributes = this._tenantThemeDao.getTenantThemeAttributes(tenantId);
        if (tenantThemeAttributes.isEmpty()) {
            throw new NoSuchElementException("No Theme for tenantId: '" + tenantId + "'!");
        }
        String logoId = this._tenantService.getTenantById(tenantId).map(Tenant::getLogoId).orElse(null);
        String globalHighlightColor = tenantThemeAttributes.stream().filter(attribute -> attribute.getThemeAttribute().equals("GLOBAL_HIGHLIGHT_COLOR")).findFirst().orElseThrow(() -> new NoSuchElementException("No GLOBAL_HIGHLIGHT_COLOR for tenantId: '" + tenantId + "'!")).getThemeValue();
        HashMap<CoreApp, String> appColors = new HashMap<CoreApp, String>();
        for (CoreApp app : CoreApp.values()) {
            String appColor = tenantThemeAttributes.stream().filter(attribute -> attribute.getThemeAttribute().equals("APP_COLOR_" + app.name()) || app.equals((Object)CoreApp.CONVERSATIONS) && attribute.getThemeAttribute().equals("APP_COLOR_CHAT") || app.equals((Object)CoreApp.SOCIAL) && attribute.getThemeAttribute().equals("APP_COLOR_CONNECT") || app.equals((Object)CoreApp.ARCHIVED_NEWS) && attribute.getThemeAttribute().equals("APP_COLOR_NEWS")).findFirst().orElseThrow(() -> new NoSuchElementException("No APP_COLOR for app: '" + app + "'!")).getThemeValue();
            appColors.put(app, appColor);
        }
        return new Theme(tenantId, globalHighlightColor, logoId, appColors);
    }

    @Nonnull
    @Deprecated
    public de.justsoftware.onx.design.shared.model.Theme getLegacyTheme(@Nullable TenantId tenantId) {
        if (tenantId != null) {
            Theme theme = this.getTheme(tenantId);
            return this.toLegacy(theme);
        }
        return this._legacyThemeService.getDefaultTheme();
    }

    public void upsertTenantThemeAttribute(TenantId tenantId, String themeAttribute, String themeValue) {
        this._tenantThemeDao.upsertTenantThemeAttribute(tenantId, themeAttribute, themeValue);
    }

    @Nonnull
    private de.justsoftware.onx.design.shared.model.Theme toLegacy(Theme theme) {
        ThemeId themeId = new ThemeId(-1L);
        ImmutableSet.Builder elementBuilder = ImmutableSet.builder();
        elementBuilder.add((Object)new ThemeAttribute(themeId, theme.getGlobalHighlightColor(), ThemeAttributeType.HORIZONTAL_NAVIGATION_NOTIFICATION_COUNT_COLOR));
        theme.getAppColors().forEach((app, appColorValue) -> elementBuilder.add((Object)new ThemeAttribute(themeId, (String)appColorValue, app.getThemeAttributeType())));
        return new de.justsoftware.onx.design.shared.model.Theme(themeId, null, (ImmutableSet<ThemeAttribute>)elementBuilder.build());
    }
}

