/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.tenant.integration.persistence.ibatis;

import de.justsoftware.onx.common.integration.persistence.StatementBuilderFactory;
import de.justsoftware.onx.common.integration.persistence.ibatis.IbatisStandardResultBuilder;
import de.justsoftware.onx.common.integration.persistence.ibatis.IbatisStatementBuilder;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.TenantId;
import de.justsoftware.onx.tenant.integration.persistence.EntityTenantDAO;
import java.util.function.BiConsumer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class IbatisEntityTenantDAO
implements EntityTenantDAO {
    private final IbatisStatementBuilder _statementBuilder;

    @Autowired
    public IbatisEntityTenantDAO(StatementBuilderFactory statementBuilderFactory) {
        this._statementBuilder = statementBuilderFactory.ibatistStatementBuilder("EntityTenant");
    }

    @Override
    public int forAllEntityTenants(BiConsumer<TenantId, String> tenantConsumer) {
        return ((IbatisStandardResultBuilder)this._statementBuilder.select("forAllEntityTenants").noParam()).executeWithBiConsumer("tenantId", "name", tenantConsumer);
    }

    @Override
    public EntityId getEntityIdForEntityTenant(TenantId tenantId) {
        return (EntityId)this._statementBuilder.select("selectEntityIdForTenant").param(tenantId).singleObject();
    }

    @Override
    public void delete(EntityId entityId) {
        this._statementBuilder.delete("deleteEntityTenant").param(entityId);
    }
}

