/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.tenant.integration.kafka.impl;

import com.freiheit.toro.admin.shared.server.superoperty.Settings;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.io.ByteSource;
import de.justsoftware.kafka.client.KafkaCleaningProducer;
import de.justsoftware.kafka.client.KafkaCleaningProducerState;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.model.ProfileId;
import de.justsoftware.onx.container.business.EntityAdministrationWorkflowService;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityMember;
import de.justsoftware.onx.container.shared.model.TenantId;
import de.justsoftware.onx.design.business.ThemeService;
import de.justsoftware.onx.design.persistence.ThemeDao;
import de.justsoftware.onx.design.shared.model.Theme;
import de.justsoftware.onx.design.shared.model.ThemeAttribute;
import de.justsoftware.onx.design.shared.model.ThemeAttributeType;
import de.justsoftware.onx.design.shared.model.ThemeId;
import de.justsoftware.onx.drive.business.DriveInternalApiConnector;
import de.justsoftware.onx.server.model.TenantKafkaDto;
import de.justsoftware.onx.storage.business.StorageServerService;
import de.justsoftware.onx.tenant.integration.kafka.TenantMigrationService;
import de.justsoftware.onx.tenant.integration.persistence.EntityTenantDAO;
import de.justsoftware.onx.tenant.integration.persistence.TenantDAO;
import de.justsoftware.permission.client.model.CoreApp;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.io.FileUtils;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class TenantMigrationServiceImpl
implements TenantMigrationService {
    @VisibleForTesting
    static final String TENANT_MIGRATION_TOPIC = "just.toro.migration.tenants";
    private static final Logger LOG = LoggerFactory.getLogger(TenantMigrationServiceImpl.class);
    private final KafkaCleaningProducer<String, String> _producer;
    private final EntityTenantDAO _entityTenantDAO;
    private final Settings _settings;
    private final TenantDAO _tenantDAO;
    private final ThemeService _themeService;
    private final ThemeDao _themeDao;
    private final EntityAdministrationWorkflowService _entityAdministrationWorkflowService;
    private final StorageServerService _storageServerService;
    private final DriveInternalApiConnector _driveInternalApiConnector;

    @Autowired
    public TenantMigrationServiceImpl(@Nullable @Qualifier(value="KAFKA_STRING_PRODUCER") KafkaCleaningProducer<String, String> producer, EntityTenantDAO entityTenantDAO, Settings settings, TenantDAO tenantDAO, ThemeService themeService, ThemeDao themeDao, EntityAdministrationWorkflowService entityAdministrationWorkflowService, StorageServerService storageServerService, DriveInternalApiConnector driveInternalApiConnector) {
        this._producer = producer;
        this._entityTenantDAO = entityTenantDAO;
        this._settings = settings;
        this._tenantDAO = tenantDAO;
        this._themeService = themeService;
        this._themeDao = themeDao;
        this._entityAdministrationWorkflowService = entityAdministrationWorkflowService;
        this._storageServerService = storageServerService;
        this._driveInternalApiConnector = driveInternalApiConnector;
    }

    @Override
    @SuppressFBWarnings(value={"RCN"}, justification="false positives for try with resource https://github.com/spotbugs/spotbugs/issues/756")
    public void migrateTenants() {
        if (this._producer == null) {
            LOG.warn("Abort migrateTenants because _producer is null!");
            return;
        }
        try (KafkaCleaningProducerState state = this._producer.beginRefill(new String[]{TENANT_MIGRATION_TOPIC});){
            int numberOfEntityTenants = this._entityTenantDAO.forAllEntityTenants(this::migrateMultiTenant);
            if (numberOfEntityTenants == 0) {
                this.migrateSingleTenant();
            }
            state.finishRefill();
        }
    }

    private void migrateMultiTenant(TenantId tenantId, String tenantName) {
        EntityId rootEntityId = this._entityTenantDAO.getEntityIdForEntityTenant(tenantId);
        if (rootEntityId == null) {
            LOG.warn("No root entity found could not perform migration for tenant " + tenantId);
            return;
        }
        ThemeId rootThemeId = this._themeDao.findThemeByEntityId(rootEntityId);
        Theme theme = this.getTenantTheme(rootThemeId);
        String storageId = this.getLogoId(theme);
        String documentId = storageId != null ? this.migrateTenantLogo(tenantId, storageId) : null;
        String globalHighlightColor = this.getGlobalHighlightColor(theme);
        Map<CoreApp, String> appColors = this.getAppColors(theme);
        List<ProfileId> managers = this.getManagers(rootEntityId);
        TenantKafkaDto tenantKafkaDto = new TenantKafkaDto.Builder().setTenantId(tenantId).setName(tenantName).setLogoId(documentId).setGlobalHighlightColor(globalHighlightColor).setManagers(managers).setAppColors(appColors).setHasManualPermissions(this.createHasManualPermissions()).build();
        this.publishToKafka(tenantKafkaDto);
    }

    @Nullable
    private String migrateTenantLogo(TenantId tenantId, String storageId) {
        String documentId;
        String path = "images/original/entity/" + storageId;
        try {
            ByteSource byteSource = this._storageServerService.loadFileFromStorageServer(path);
            InputStream inputStream = byteSource.openBufferedStream();
            String[] filenameParts = storageId.split("\\.(?=[^\\.]+$)");
            File tempFile = File.createTempFile(filenameParts[0], "." + filenameParts[1]);
            FileUtils.copyInputStreamToFile((InputStream)inputStream, (File)tempFile);
            documentId = this._driveInternalApiConnector.replaceFile(tenantId, tempFile, PersonId.valueOf(0L), null).asString().replace("DRIVE_", "");
            FileUtils.deleteQuietly((File)tempFile);
        }
        catch (IOException ex) {
            ex.printStackTrace();
            LOG.error("Couldn't load file for storageId: " + storageId);
            documentId = null;
        }
        return documentId;
    }

    private void migrateSingleTenant() {
        Theme defaultTheme = this._themeService.getDefaultTheme();
        String globalHighlightColor = this.getGlobalHighlightColor(defaultTheme);
        Map<CoreApp, String> appColors = this.getAppColors(defaultTheme);
        List<TenantId> allTenants = this._tenantDAO.getAllTenants();
        if (allTenants.size() > 1) {
            LOG.info("Skip single tenant migration since multiple tenants exist!");
            return;
        }
        Optional singleTenantId = allTenants.stream().findFirst();
        if (singleTenantId.isEmpty()) {
            LOG.info("Skip single tenant migration since no tenant exist!");
            return;
        }
        TenantId tenantId = (TenantId)singleTenantId.get();
        String storageId = this.getLogoId(defaultTheme);
        String documentId = storageId != null ? this.migrateTenantLogo(tenantId, storageId) : null;
        TenantKafkaDto tenantKafkaDto = new TenantKafkaDto.Builder().setTenantId(tenantId).setName(this._settings.getDefaultSiteTitle()).setLogoId(documentId).setGlobalHighlightColor(globalHighlightColor).setManagers(Collections.emptyList()).setAppColors(appColors).setHasManualPermissions(this.createHasManualPermissions()).build();
        this.publishToKafka(tenantKafkaDto);
    }

    private void publishToKafka(TenantKafkaDto tenantKafkaDto) {
        if (this._producer == null) {
            return;
        }
        String tenantIdAsString = tenantKafkaDto.getTenantId().asString();
        this._producer.send(new ProducerRecord(TENANT_MIGRATION_TOPIC, (Object)tenantIdAsString, (Object)tenantKafkaDto.toTopicJson()));
    }

    private Theme getTenantTheme(@Nullable ThemeId themeId) {
        if (themeId == null) {
            return this._themeService.getDefaultTheme();
        }
        Theme theme = this._themeService.getByIdUnauthorized(themeId);
        if (theme == null) {
            return this._themeService.getDefaultTheme();
        }
        return theme;
    }

    private String getLogoId(Theme theme) {
        ThemeAttribute logo = theme.getAttribute(ThemeAttributeType.BRAND_LOGO);
        return logo != null ? logo.getValue() : null;
    }

    private String getGlobalHighlightColor(Theme theme) {
        ThemeAttribute color = theme.getAttribute(ThemeAttributeType.HORIZONTAL_NAVIGATION_NOTIFICATION_COUNT_COLOR);
        return color != null ? color.getValue() : "";
    }

    private Map<CoreApp, String> getAppColors(Theme theme) {
        return Arrays.stream(CoreApp.values()).collect(Collectors.toMap(app -> app, app -> {
            ThemeAttribute attribute = theme.getAttribute(ThemeAttributeType.valueOf("APP_" + app.name() + "_BACKGROUND_COLOR"));
            return attribute != null && attribute.getValue() != null ? attribute.getValue() : "";
        }));
    }

    private List<ProfileId> getManagers(EntityId rootEntityId) {
        ArrayList<ProfileId> managers = new ArrayList<ProfileId>();
        EntityMember admin = this._entityAdministrationWorkflowService.getAdmin(rootEntityId);
        if (admin != null) {
            managers.add(admin.getPersonId().asProfileId());
        }
        this._entityAdministrationWorkflowService.getDirectCoAdmins(rootEntityId).forEach(coadmin -> managers.add(coadmin.getPersonId().asProfileId()));
        return managers;
    }

    private Map<CoreApp, Boolean> createHasManualPermissions() {
        HashMap<CoreApp, Boolean> hasManualPermissions = new HashMap<CoreApp, Boolean>();
        hasManualPermissions.put(CoreApp.DRIVE, true);
        hasManualPermissions.put(CoreApp.PEOPLE, true);
        return hasManualPermissions;
    }
}

