/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.tenant.integration.kafka.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import de.justsoftware.onx.common.deletion.DeletionService;
import de.justsoftware.onx.common.rest.JucoObjectMapper;
import de.justsoftware.onx.common.shared.server.TransactionHelper;
import de.justsoftware.onx.container.shared.model.IdParseException;
import de.justsoftware.onx.container.shared.model.TenantId;
import de.justsoftware.onx.kafka.AbstractKafkaConsumer;
import de.justsoftware.onx.kafka.KafkaConfigurationProvider;
import de.justsoftware.onx.kafka.KafkaConsumerContext;
import de.justsoftware.onx.tenant.business.TenantService;
import de.justsoftware.onx.tenant.integration.kafka.model.TenantKafkaModel;
import de.justsoftware.onx.tenantdesign.ThemeService;
import de.justsoftware.onx.tenantinvitation.business.impl.TenantInvitationService;
import java.util.NoSuchElementException;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
@Lazy(value=false)
@ParametersAreNonnullByDefault
public class TenantConsumerImpl
extends AbstractKafkaConsumer<String, String> {
    private static final String TENANTS_TOPIC = "just.tenants";
    private static final Logger LOG = LoggerFactory.getLogger(TenantConsumerImpl.class);
    private final TenantService _tenantService;
    private final ThemeService _themeService;
    private final TenantInvitationService _tenantInvitationService;
    private final JucoObjectMapper _jucoObjectMapper;
    private final DeletionService _deletionService;

    @Autowired
    public TenantConsumerImpl(KafkaConfigurationProvider configProvider, TransactionHelper transactionHelper, TenantService tenantService, ThemeService themeService, TenantInvitationService tenantInvitationService, JucoObjectMapper jucoObjectMapper, DeletionService deletionService) {
        super(configProvider.stringConsumer("just.toro.TenantConsumer"), transactionHelper, TENANTS_TOPIC);
        this._tenantService = tenantService;
        this._themeService = themeService;
        this._tenantInvitationService = tenantInvitationService;
        this._jucoObjectMapper = jucoObjectMapper;
        this._deletionService = deletionService;
    }

    @Override
    protected Logger getLog() {
        return LOG;
    }

    @Override
    protected void process(ConsumerRecords<String, String> records, KafkaConsumerContext context) {
        for (ConsumerRecord record : records) {
            try {
                TenantId tenantId = TenantId.parse((String)record.key()).orElseThrow();
                if (record.value() == null) {
                    this._tenantService.deleteTenant(tenantId);
                    this._tenantService.getEntityIdForTenantId(tenantId).ifPresent(this._tenantService::deleteEntityTenant);
                    return;
                }
                TenantKafkaModel tenantKafkaModel = (TenantKafkaModel)this._jucoObjectMapper.readValue((String)record.value(), TenantKafkaModel.class);
                if (tenantKafkaModel.getTheme() == null) {
                    LOG.info(String.format("Skipping record. Outdated version of TenantKafkaModel. %s", record));
                    return;
                }
                this._tenantService.createOrUpdateTenant(tenantId, tenantKafkaModel.getName(), tenantKafkaModel.getTheme().getLogoId(), tenantKafkaModel.getDeeplKey());
                tenantKafkaModel.getTenantColors().forEach((key, value) -> this._themeService.upsertTenantThemeAttribute(tenantId, (String)key, (String)value));
                String invitationCode = tenantKafkaModel.getInvitationCode();
                this._tenantInvitationService.setTenantInvitationCode(invitationCode, tenantId);
            }
            catch (IllegalArgumentException e) {
                LOG.warn(String.format("Skipping record. You are trying to delete a tenant through kafka. This is not yet implemented. %s", record), (Throwable)e);
            }
            catch (JsonProcessingException e) {
                LOG.warn(String.format("Skipping record. Could not parse record value to TenantKafkaModel. %s", record), (Throwable)e);
            }
            catch (IdParseException | NoSuchElementException e) {
                LOG.warn(String.format("Skipping record. Could not parse record key to TenantId. %s", record), (Throwable)e);
            }
        }
    }
}

