/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.tenant.integration.kafka.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.justsoftware.kafka.client.KafkaCleaningProducer;
import de.justsoftware.kafka.client.KafkaCleaningProducerState;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.container.shared.model.AbstractUUIDBasedItemId;
import de.justsoftware.onx.container.shared.model.TenantId;
import de.justsoftware.onx.tenant.integration.kafka.PersonTenantPublisher;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class PersonTenantPublisherImpl
implements PersonTenantPublisher {
    private static final Logger LOGGER = LoggerFactory.getLogger(PersonTenantPublisherImpl.class);
    private static final String TOPIC = "just.persons.tenantIds";
    private final KafkaCleaningProducer<String, String> _producer;
    private final ObjectMapper _objectMapper = new ObjectMapper();

    @Autowired
    public PersonTenantPublisherImpl(@Nullable @Qualifier(value="KAFKA_STRING_PRODUCER") KafkaCleaningProducer<String, String> personTenantsProducer) {
        this._producer = personTenantsProducer;
    }

    @Override
    public void publishPersonTenants(PersonId personId, Set<TenantId> tenantIds) {
        if (this._producer == null) {
            return;
        }
        Set tenantIdsAsString = tenantIds.stream().map(AbstractUUIDBasedItemId::asString).collect(Collectors.toSet());
        try {
            String value = tenantIds.isEmpty() ? null : this._objectMapper.writeValueAsString(tenantIdsAsString);
            this._producer.send(new ProducerRecord(TOPIC, (Object)personId.asProfileId().asString(), (Object)value));
        }
        catch (JsonProcessingException e) {
            LOGGER.error("Could not send person tenants", (Throwable)e);
        }
    }

    @Override
    public void republish(Runnable callback) {
        KafkaCleaningProducerState cleaningState = this._producer.beginRefill(new String[]{TOPIC});
        callback.run();
        cleaningState.finishRefill();
    }
}

