/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.tenant.business.impl;

import com.google.common.collect.ImmutableSet;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import de.justsoftware.onx.authorization.business.AuthorizationContext;
import de.justsoftware.onx.common.business.configfile.ConfigService;
import de.justsoftware.onx.common.business.events.ServerEventHandler;
import de.justsoftware.onx.common.deletion.DeletionService;
import de.justsoftware.onx.common.deletion.TransactionCallbackWithDeleteAction;
import de.justsoftware.onx.common.deletion.model.DeleteAction;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.model.action.Action;
import de.justsoftware.onx.common.shared.model.action.StaticPermissionAction;
import de.justsoftware.onx.common.shared.util.StringUtil;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.container.shared.model.TenantId;
import de.justsoftware.onx.events.PersonDeletedEvent;
import de.justsoftware.onx.security.SecurityUtils;
import de.justsoftware.onx.tenant.business.PersonTenantService;
import de.justsoftware.onx.tenant.business.TenantService;
import de.justsoftware.onx.tenant.integration.persistence.EntityTenantDAO;
import de.justsoftware.onx.tenant.integration.persistence.TenantDAO;
import de.justsoftware.onx.tenant.integration.persistence.model.Tenant;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.TransactionStatus;

@Service
@ParametersAreNonnullByDefault
public class TenantServiceImpl
implements TenantService,
ServerEventHandler {
    private static final PersonId DELETED_PERSON_ID = new PersonId(-1L);
    private final TenantDAO _tenantDAO;
    private final ConfigService _configService;
    private final PersonTenantService _personTenantService;
    private final DeletionService _deletionService;
    private final EntityTenantDAO _entityTenantDAO;

    @Autowired
    public TenantServiceImpl(TenantDAO tenantDAO, ConfigService configService, PersonTenantService personTenantService, DeletionService deletionService, EntityTenantDAO entityTenantDAO) {
        this._tenantDAO = tenantDAO;
        this._configService = configService;
        this._personTenantService = personTenantService;
        this._deletionService = deletionService;
        this._entityTenantDAO = entityTenantDAO;
    }

    @Override
    public Optional<TenantId> getOnlyTenant() {
        List<TenantId> tenants = this._tenantDAO.getAllTenants();
        if (tenants.size() != 1) {
            return Optional.empty();
        }
        return Optional.of(tenants.iterator().next());
    }

    @Override
    public Optional<Tenant> getTenantById(TenantId tenantId) {
        return this._tenantDAO.get(tenantId);
    }

    @Override
    public void deleteEntityTenant(EntityId id) {
        this._entityTenantDAO.delete(id);
    }

    @Override
    public void deleteTenant(TenantId tenantId, Consumer<Runnable> afterCommit) {
        this._tenantDAO.delete(tenantId);
    }

    @Override
    public void deleteTenant(final TenantId tenantId) {
        this._deletionService.deleteInTransactionWithDeleteAction(tenantId, DELETED_PERSON_ID, new TransactionCallbackWithDeleteAction<Object>(){

            @Override
            public Object doInTransactionWithDeleteAction(TransactionStatus status, DeleteAction deleteAction) {
                TenantServiceImpl.this._tenantDAO.delete(tenantId);
                return this;
            }
        });
    }

    @Override
    public void createOrUpdateTenant(TenantId tenantId, String name, String logoId, String deeplKey) {
        this._tenantDAO.upsert(tenantId, name, logoId, deeplKey);
    }

    @Override
    public boolean switchToTenant(AuthorizationContext authContext, TenantId newTenantId) {
        authContext.check((ItemId)newTenantId, (Action)StaticPermissionAction.READ);
        SecurityUtils.loginToTenant(newTenantId);
        Optional<TenantId> currentTenantId = SecurityUtils.getTenantId();
        return currentTenantId.isPresent() && newTenantId.equals(currentTenantId.get());
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onPersonDeleted(PersonDeletedEvent event) {
        PersonId personId = event.getPersonId();
        ImmutableSet<TenantId> tenantIdsForPerson = this._personTenantService.getTenantIdsForPerson(personId);
        tenantIdsForPerson.forEach(tenantId -> this._personTenantService.deletePersonFromTenant(personId, (TenantId)tenantId));
    }

    @Override
    public Optional<EntityId> getEntityIdForTenantId(TenantId tenantId) {
        return Optional.ofNullable(this._entityTenantDAO.getEntityIdForEntityTenant(tenantId));
    }

    @Override
    public boolean isDeeplTranslationEnabled(TenantId tenantId) {
        String key = this.getTenantById(tenantId).map(Tenant::getDeeplKey).orElse(null);
        return !StringUtil.isBlank(key);
    }
}

