/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.tenant.business.impl;

import de.justsoftware.onx.ada.AdminInternalConnector;
import de.justsoftware.onx.people.business.PeopleInternalApiConnector;
import de.justsoftware.onx.server.business.JucoServerVersionUpdateProcessor;
import de.justsoftware.onx.server.business.UpdateBehaviour;
import de.justsoftware.onx.server.model.JucoVersionUpdateProcess;
import de.justsoftware.onx.tenant.integration.kafka.TenantMigrationService;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@ParametersAreNonnullByDefault
@Service
public class MigrateAllTenantsUpdateProcessor
implements JucoServerVersionUpdateProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(MigrateAllTenantsUpdateProcessor.class);
    private final AdminInternalConnector _adminInternalConnector;
    private final TenantMigrationService _tenantMigrationService;
    private final PeopleInternalApiConnector _peopleInternalApiConnector;

    @Autowired
    public MigrateAllTenantsUpdateProcessor(AdminInternalConnector adminInternalConnector, TenantMigrationService tenantMigrationService, PeopleInternalApiConnector peopleInternalApiConnector) {
        this._adminInternalConnector = adminInternalConnector;
        this._tenantMigrationService = tenantMigrationService;
        this._peopleInternalApiConnector = peopleInternalApiConnector;
    }

    @Override
    @Nonnull
    public JucoVersionUpdateProcess getProcessType() {
        return JucoVersionUpdateProcess.MIGRATE_ALL_TENANTS;
    }

    @Override
    @Nonnull
    public UpdateBehaviour getUpdateBehaviour() {
        return UpdateBehaviour.onceOnMasterForVersion(this, "12.2.0");
    }

    @Override
    public int getProcessorVersion() {
        return 2;
    }

    @Override
    public boolean preconditionsMet() {
        return this._peopleInternalApiConnector.hasSameJucoVersion();
    }

    @Override
    public void process() {
        LOG.info("Starting migrateTenants.");
        this._tenantMigrationService.migrateTenants();
        this._adminInternalConnector.republishAllTenants();
        this._peopleInternalApiConnector.publishAllUserGroups();
    }
}

