/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.tasks.integration.persistence;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.SetMultimap;
import de.justsoftware.onx.authorization.business.ProfileRole;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.tasks.authorization.TaskRight;
import de.justsoftware.onx.tasks.business.model.TaskBO;
import de.justsoftware.onx.tasks.business.model.TaskFilter;
import de.justsoftware.onx.tasks.business.model.TaskListBO;
import de.justsoftware.onx.tasks.integration.persistence.TaskCreateModel;
import de.justsoftware.onx.tasks.shared.model.TaskId;
import de.justsoftware.onx.tasks.shared.model.TaskListId;
import de.justsoftware.onx.tasks.shared.model.TaskStatus;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.joda.time.DateTime;

@ParametersAreNonnullByDefault
public interface TaskDAO {
    @Nonnull
    public TaskId createTask(TaskCreateModel var1);

    @Nonnull
    public ImmutableSet<TaskId> createTasks(Iterable<TaskCreateModel> var1);

    public void setStatus(Set<TaskId> var1, TaskStatus var2);

    public void deleteTasksAndSubtasks(Set<TaskId> var1);

    public void setName(TaskId var1, String var2);

    public void setDescription(TaskId var1, String var2);

    public void setDueDate(TaskId var1, @Nullable DateTime var2);

    @Nonnull
    public ImmutableMap<TaskId, TaskBO> getTasksByIds(Set<TaskId> var1);

    @Nonnull
    public ImmutableSet<TaskId> getTaskIdsByTaskFilter(TaskFilter var1);

    @Nonnull
    public ImmutableMap<TaskId, Long> getTaskPositions(String var1, Set<TaskId> var2);

    @Nonnull
    public ImmutableList<TaskBO> getTasksByTaskFilter(TaskFilter var1, int var2, int var3);

    public void setAssignee(TaskId var1, @Nullable PersonId var2);

    @VisibleForTesting
    public void setTaskFilterOrder(String var1, ImmutableSet<TaskId> var2);

    @Nonnull
    public ImmutableSetMultimap<TaskId, PersonId> filterSubtaskAssignees(SetMultimap<TaskId, PersonId> var1);

    @Nonnull
    public ImmutableSetMultimap<TaskId, PersonId> filterSubtaskOwners(SetMultimap<TaskId, PersonId> var1);

    @Nonnull
    public ImmutableMultiset<TaskStatus> getTaskCountByStatus(TaskFilter var1);

    public void insertTaskList(TaskListId var1, String var2, Map<ProfileRole, TaskRight> var3);

    public void deleteTaskLists(Set<TaskListId> var1);

    @Nonnull
    public ImmutableList<TaskListBO> getTaskListsWithRoles(Set<ProfileRole> var1);

    @Nonnull
    public ImmutableMap<TaskListId, TaskListBO> getTaskListsByIds(Set<TaskListId> var1);

    @Nonnull
    public ImmutableTable<TaskListId, ProfileRole, TaskRight> getTaskListPermissions(Set<TaskListId> var1);

    public void updateTaskList(TaskListId var1, String var2, Map<ProfileRole, TaskRight> var3);

    @Nonnull
    public ImmutableTable<TaskListId, ProfileRole, TaskRight> filterTaskListPermissions(SetMultimap<TaskListId, ProfileRole> var1);

    @VisibleForTesting
    public void deleteTaskPosition(String var1, TaskId var2);

    @VisibleForTesting
    public void insertTaskPosition(String var1, TaskId var2, long var3);

    @VisibleForTesting
    public void moveTasks(TaskFilter var1, long var2, long var4);

    @VisibleForTesting
    public void indexTasks(TaskFilter var1);

    public void reorderTasks(TaskFilter var1, TaskId var2, TaskId var3);
}

