/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.tasks.business.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class TaskApiCreateModel {
    private final long _ownerId;
    private final long _assigneeId;
    private final String _name;
    private final String _description;
    private final String _parentId;
    private final Attachment _attachment;

    public TaskApiCreateModel(@JsonProperty(value="ownerId", required=true) long ownerId, @JsonProperty(value="assigneeId", required=true) long assigneeId, @JsonProperty(value="name", required=true) String name, @JsonProperty(value="description", required=false) String description, @JsonProperty(value="parentId", required=false) @Nullable String parentId, @JsonProperty(value="attachment", required=false) Attachment attachment) {
        this._ownerId = ownerId;
        this._assigneeId = assigneeId;
        this._attachment = attachment;
        this._name = name.trim();
        this._description = description != null ? description.trim() : "";
        this._parentId = parentId;
    }

    public long getOwnerId() {
        return this._ownerId;
    }

    public long getAssigneeId() {
        return this._assigneeId;
    }

    @Nonnull
    public String getName() {
        return this._name;
    }

    @Nonnull
    public String getDescription() {
        return this._description;
    }

    @CheckForNull
    public String getParentId() {
        return this._parentId;
    }

    @CheckForNull
    public Attachment getAttachment() {
        return this._attachment;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("ownerId", this._ownerId).add("assigneeId", this._assigneeId).add("name", (Object)this._name).add("description", (Object)this._description).add("parentId", (Object)this._parentId).add("attachment", (Object)this._attachment).toString();
    }

    @ParametersAreNonnullByDefault
    public static class Attachment {
        private final String _name;
        private final String _url;

        public Attachment(@JsonProperty(value="name", required=false) String name, @JsonProperty(value="url", required=false) String url) {
            this._name = name;
            this._url = url;
        }

        @Nonnull
        public String getName() {
            return this._name;
        }

        @Nonnull
        public String getUrl() {
            return this._url;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this.getClass()).add("name", (Object)this._name).add("url", (Object)this._url).toString();
        }
    }
}

