/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.tasks.business.impl;

import com.google.common.base.Strings;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.common.deletion.DeletionService;
import de.justsoftware.onx.common.deletion.TransactionCallbackWithDeleteAction;
import de.justsoftware.onx.common.deletion.model.DeleteAction;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.container.shared.model.Identifiables;
import de.justsoftware.onx.person.business.PersonService;
import de.justsoftware.onx.tasks.authorization.TaskAction;
import de.justsoftware.onx.tasks.authorization.TaskAuthorizationContext;
import de.justsoftware.onx.tasks.authorization.model.TaskItem;
import de.justsoftware.onx.tasks.business.TaskFilterLockService;
import de.justsoftware.onx.tasks.business.TaskService;
import de.justsoftware.onx.tasks.business.model.TaskBO;
import de.justsoftware.onx.tasks.business.model.TaskFilter;
import de.justsoftware.onx.tasks.integration.persistence.TaskCreateModel;
import de.justsoftware.onx.tasks.integration.persistence.TaskDAO;
import de.justsoftware.onx.tasks.shared.model.SubtasksFilterId;
import de.justsoftware.onx.tasks.shared.model.TaskAuthorizationItemId;
import de.justsoftware.onx.tasks.shared.model.TaskFilterId;
import de.justsoftware.onx.tasks.shared.model.TaskId;
import de.justsoftware.onx.tasks.shared.model.TaskListId;
import de.justsoftware.onx.tasks.shared.model.TaskStatus;
import de.justsoftware.toolbox.clock.Clock;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.joda.time.DateTime;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.TransactionStatus;

@Service
@ParametersAreNonnullByDefault
public class TaskServiceImpl
implements TaskService {
    private static final String ASSIGNMENTS_TOPIC = "just.tasks.assignments";
    private static final String COMPLETIONS_TOPIC = "just.tasks.completions";
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskServiceImpl.class);
    private static final Callback LOG_ERROR_CALLBACK = new Callback(){

        public void onCompletion(RecordMetadata metadata, Exception exception) {
            if (exception != null) {
                LOGGER.error("Could not publish task assignment", (Throwable)exception);
            }
        }
    };
    private final TaskDAO _dao;
    private final Producer<String, String> _producer;
    private final Clock _clock;
    private final PersonService _personService;
    private final DeletionService _deletionService;
    private final TaskFilterLockService _taskFilterLockService;

    @Autowired
    public TaskServiceImpl(TaskDAO dao, TaskFilterLockService taskFilterLockService, Producer<String, String> producer, Clock clock, PersonService personService, DeletionService deletionService) {
        this._dao = dao;
        this._taskFilterLockService = taskFilterLockService;
        this._producer = producer;
        this._clock = clock;
        this._personService = personService;
        this._deletionService = deletionService;
    }

    @Override
    public void setAssignee(TaskId taskId, @Nullable PersonId assignee, TaskAuthorizationContext authCtx) {
        PersonId loggedInUser = authCtx.getPersonId();
        authCtx.check(taskId, TaskAction.TASK_EDIT);
        if (assignee != null) {
            authCtx.checkProfileVisibility((ImmutableSet<PersonId>)ImmutableSet.of((Object)assignee));
        }
        this._dao.setAssignee(taskId, assignee);
        this.publishAssignment(taskId, assignee, loggedInUser);
    }

    private void publishAssignment(TaskId taskId, @Nullable PersonId assignee, PersonId assignor) {
        if (this._producer != null) {
            try {
                JSONObject value = new JSONObject();
                value.put("assignee", assignee != null ? assignee.asProfileId().toString() : null);
                value.put("assignor", (Object)assignor.asProfileId().toString());
                this._producer.send(new ProducerRecord(ASSIGNMENTS_TOPIC, null, Long.valueOf(this._clock.nowMillis()), (Object)taskId.asString(), (Object)value.toString()), LOG_ERROR_CALLBACK);
            }
            catch (JSONException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public void setStatus(TaskId taskId, TaskStatus status, PersonId executor, TaskAuthorizationContext authCtx) {
        PersonId loggedInUser = authCtx.getNullablePersonId();
        if (executor.equals(loggedInUser)) {
            authCtx.check(taskId, TaskAction.TASK_EDIT);
        } else {
            authCtx.check(taskId, TaskAction.TASK_CREATE_FOR_OTHERS);
        }
        this._dao.setStatus((Set<TaskId>)ImmutableSet.of((Object)taskId), status);
        if (this._producer != null) {
            try {
                JSONObject value = new JSONObject();
                value.put("executor", (Object)executor.asProfileId().toString());
                value.put("completed", status.equals((Object)TaskStatus.COMPLETED));
                this._producer.send(new ProducerRecord(COMPLETIONS_TOPIC, null, Long.valueOf(this._clock.nowMillis()), (Object)taskId.asString(), (Object)value.toString()), LOG_ERROR_CALLBACK);
            }
            catch (JSONException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public ImmutableMap<TaskId, TaskBO> getTasks(Set<TaskId> ids) {
        return this._dao.getTasksByIds(ids);
    }

    @Override
    public ImmutableMap<TaskId, TaskBO> getVisibleTasks(Set<TaskId> taskIds, TaskAuthorizationContext authCtx) {
        ImmutableMap<TaskId, TaskBO> result = this.getTasks(taskIds);
        FluentIterable items = FluentIterable.from((Iterable)result.values()).transform(TaskItem.FROM_TASKBO);
        Iterable filtered = authCtx.filterAllowedItems(items, TaskAction.TASK_READ);
        return FluentIterable.from(filtered).transform(TaskItem.TO_TASKBO).uniqueIndex(Identifiables.toId());
    }

    @Override
    public void reorderTasks(TaskFilterId filterId, TaskId taskId, TaskId targetTaskId, TaskAuthorizationContext authCtx) {
        if (taskId.equals(targetTaskId)) {
            return;
        }
        TaskFilter filter = filterId.accept(new FilterBuilderForFilterIdVisitor(authCtx, TaskAction.TASK_REORDER, TaskAction.TASK_REORDER)).build();
        this._taskFilterLockService.acquireAndExecute(filter.getTaskFilterId(), () -> this._dao.reorderTasks(filter, taskId, targetTaskId));
    }

    @Override
    public void setName(TaskId taskId, String name, TaskAuthorizationContext authCtx) {
        authCtx.check(taskId, TaskAction.TASK_EDIT);
        this._dao.setName(taskId, name);
    }

    @Override
    public TaskId createRecommendationTask(PersonId ownerId, PersonId assigneeId, String name, String description, TaskId parentTaskId, String attachmentName, String attachmentUrl) {
        if (name.isEmpty()) {
            throw new IllegalArgumentException("Name cannot be empty");
        }
        if (this._personService.getPersonById(ownerId) == null) {
            throw new IllegalArgumentException("Owner does not exist");
        }
        TaskCreateModel createModel = TaskCreateModel.create(ownerId, this._clock.now()).setName(name);
        if (assigneeId != null) {
            if (this._personService.getPersonById(assigneeId) == null) {
                throw new IllegalArgumentException("Assignee does not exist");
            }
            createModel.setAssignee(assigneeId);
        }
        createModel.setDescription(description).setParentTaskId(parentTaskId).setAttachmentName(attachmentName).setAttachmentUrl(attachmentUrl);
        TaskId taskId = this._dao.createTask(createModel);
        if (assigneeId != null) {
            this.publishAssignment(taskId, assigneeId, ownerId);
        }
        return taskId;
    }

    @Override
    public TaskId createTask(TaskFilterId filterId, String name, TaskAuthorizationContext authCtx) {
        TaskCreateModel createModel = filterId.accept(new ApplyFilterToCreateModelVisitor(authCtx.getPersonId()));
        TaskId parentTaskId = createModel.getParentTaskId();
        TaskListId taskListId = createModel.getTaskListId();
        if (parentTaskId != null) {
            TaskBO parent = (TaskBO)this.getTasks((Set<TaskId>)ImmutableSet.of((Object)parentTaskId)).get((Object)parentTaskId);
            if (parent == null) {
                throw new IllegalArgumentException("Parent Task does not exists!");
            }
            authCtx.check(new TaskItem(parent), TaskAction.TASK_CREATE);
            if (parent.getParentId() instanceof TaskId) {
                throw new IllegalStateException("Creation of sub-sub-tasks is not allowed");
            }
        } else if (taskListId != null) {
            authCtx.check(taskListId, TaskAction.TASK_CREATE);
        } else {
            authCtx.check(TaskAction.TASK_CREATE);
        }
        createModel.setName(Strings.nullToEmpty((String)name).trim());
        return this._dao.createTask(createModel);
    }

    @Override
    public void deleteTaskAndSubtasks(final TaskId taskId, TaskAuthorizationContext authCtx) {
        authCtx.check(taskId, TaskAction.TASK_DELETE);
        this._deletionService.deleteInTransactionWithDeleteAction(taskId, authCtx.getPersonId(), new TransactionCallbackWithDeleteAction<Object>(){

            @Override
            public Object doInTransactionWithDeleteAction(TransactionStatus status, DeleteAction deleteAction) {
                TaskServiceImpl.this._dao.deleteTasksAndSubtasks((Set<TaskId>)ImmutableSet.of((Object)taskId));
                return this;
            }
        });
    }

    @Override
    public void setDescription(TaskId taskId, String description, TaskAuthorizationContext authCtx) {
        authCtx.check(taskId, TaskAction.TASK_EDIT);
        this._dao.setDescription(taskId, description);
    }

    @Override
    public void setDueDate(TaskId taskId, DateTime dueDate, TaskAuthorizationContext authCtx) {
        authCtx.check(taskId, TaskAction.TASK_EDIT);
        this._dao.setDueDate(taskId, dueDate);
    }

    @Override
    public ImmutableList<TaskBO> getTasksByFilter(TaskFilterId filterId, TaskStatus status, int skip, int max, TaskAuthorizationContext authCtx) {
        TaskFilter.TaskFilterBuilder filterBuilder = filterId.accept(new FilterBuilderForFilterIdVisitor(authCtx, TaskAction.TASK_READ, TaskAction.TASK_LIST_READ));
        return this._dao.getTasksByTaskFilter(filterBuilder.withStatus(status).build(), skip, max);
    }

    @Override
    public ImmutableMultiset<TaskStatus> getTaskCountByStatus(TaskFilterId filterId, TaskAuthorizationContext authCtx) {
        TaskFilter.TaskFilterBuilder filterBuilder = filterId.accept(new FilterBuilderForFilterIdVisitor(authCtx, TaskAction.TASK_READ, TaskAction.TASK_LIST_READ));
        return this._dao.getTaskCountByStatus(filterBuilder.build());
    }

    @Override
    public ImmutableSet<TaskAction> getAllowedActionsForFilter(TaskFilterId taskFilterId, TaskStatus taskStatus, TaskAuthorizationContext authCtx) {
        switch (taskStatus) {
            case COMPLETED: {
                return ImmutableSet.of();
            }
            case OPEN: {
                return taskFilterId.accept(new AuthorizationForFilterIdVisitor(authCtx));
            }
        }
        throw new UnsupportedOperationException("case for " + taskStatus + " is not implemented");
    }

    @ParametersAreNonnullByDefault
    private static class AuthorizationForFilterIdVisitor
    implements TaskFilterId.Visitor<ImmutableSet<TaskAction>> {
        private final TaskAuthorizationContext _authCtx;

        public AuthorizationForFilterIdVisitor(TaskAuthorizationContext authCtx) {
            this._authCtx = authCtx;
        }

        @Override
        public ImmutableSet<TaskAction> visitAssignedToMe() {
            return this.visitOwnList();
        }

        @Override
        public ImmutableSet<TaskAction> visitCreatedByMe() {
            return this.visitOwnList();
        }

        @Nonnull
        private ImmutableSet<TaskAction> visitOwnList() {
            ImmutableSet.Builder result = ImmutableSet.builder();
            if (this._authCtx.may(TaskAction.TASK_CREATE)) {
                result.add((Object)TaskAction.TASK_CREATE);
            }
            return result.add((Object)TaskAction.TASK_REORDER).build();
        }

        @Override
        public ImmutableSet<TaskAction> visitTaskList(TaskListId taskListId) {
            return this._authCtx.may((TaskAuthorizationItemId)taskListId, (Set<TaskAction>)ImmutableSet.of((Object)TaskAction.TASK_CREATE, (Object)TaskAction.TASK_LIST_MANAGE, (Object)TaskAction.TASK_REORDER));
        }

        @Override
        public ImmutableSet<TaskAction> visit(SubtasksFilterId subtasksFilterId) {
            return this._authCtx.may((TaskAuthorizationItemId)subtasksFilterId.getParentTaskId(), (Set<TaskAction>)ImmutableSet.of((Object)TaskAction.TASK_CREATE, (Object)TaskAction.TASK_REORDER));
        }
    }

    @ParametersAreNonnullByDefault
    private static final class FilterBuilderForFilterIdVisitor
    implements TaskFilterId.Visitor<TaskFilter.TaskFilterBuilder> {
        private final TaskAuthorizationContext _authCtx;
        private final TaskAction _neededTaskAction;
        private final TaskAction _neededTaskListAction;

        public FilterBuilderForFilterIdVisitor(TaskAuthorizationContext authCtx, TaskAction neededTaskAction, TaskAction neededTaskListAction) {
            this._authCtx = authCtx;
            this._neededTaskAction = neededTaskAction;
            this._neededTaskListAction = neededTaskListAction;
        }

        @Override
        public TaskFilter.TaskFilterBuilder visitAssignedToMe() {
            PersonId personId = this._authCtx.getPersonId();
            return TaskFilter.TaskFilterBuilder.forTaskFilterId("assignedToMe," + personId.getId()).withAssignee(personId);
        }

        @Override
        public TaskFilter.TaskFilterBuilder visitCreatedByMe() {
            PersonId personId = this._authCtx.getPersonId();
            return TaskFilter.TaskFilterBuilder.forTaskFilterId("createdByMe," + personId.getId()).withOwner(personId);
        }

        @Override
        public TaskFilter.TaskFilterBuilder visitTaskList(TaskListId taskListId) {
            this._authCtx.check(taskListId, this._neededTaskListAction);
            return TaskFilter.TaskFilterBuilder.forTaskFilterId(taskListId.asString()).withTaskListId(taskListId);
        }

        @Override
        public TaskFilter.TaskFilterBuilder visit(SubtasksFilterId subtasksFilterId) {
            this._authCtx.check(subtasksFilterId.getParentTaskId(), this._neededTaskAction);
            return TaskFilter.TaskFilterBuilder.forTaskFilterId(subtasksFilterId.asString()).withParentTask(subtasksFilterId.getParentTaskId());
        }
    }

    @ParametersAreNonnullByDefault
    private final class ApplyFilterToCreateModelVisitor
    implements TaskFilterId.Visitor<TaskCreateModel> {
        private final TaskCreateModel _createModel;
        private final PersonId _loggedIn;

        public ApplyFilterToCreateModelVisitor(PersonId loggedIn) {
            this._createModel = TaskCreateModel.create(loggedIn, TaskServiceImpl.this._clock.now());
            this._loggedIn = loggedIn;
        }

        @Override
        public TaskCreateModel visitAssignedToMe() {
            return this._createModel.setAssignee(this._loggedIn);
        }

        @Override
        public TaskCreateModel visitCreatedByMe() {
            return this._createModel;
        }

        @Override
        public TaskCreateModel visitTaskList(TaskListId taskListId) {
            return this._createModel.setTaskListId(taskListId).setParentTaskId(null);
        }

        @Override
        public TaskCreateModel visit(SubtasksFilterId subtasksFilterId) {
            return this._createModel.setParentTaskId(subtasksFilterId.getParentTaskId()).setTaskListId(null);
        }
    }
}

