/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.tasks.business.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Sets;
import de.justsoftware.onx.authorization.business.ProfileRole;
import de.justsoftware.onx.common.business.events.JCEventBus;
import de.justsoftware.onx.common.deletion.DeletionService;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.tasks.authorization.TaskAction;
import de.justsoftware.onx.tasks.authorization.TaskAuthorizationContext;
import de.justsoftware.onx.tasks.authorization.TaskRight;
import de.justsoftware.onx.tasks.business.TaskListService;
import de.justsoftware.onx.tasks.business.events.AddedToTaskListEvent;
import de.justsoftware.onx.tasks.business.impl.TaskListPublisher;
import de.justsoftware.onx.tasks.business.model.TaskFilter;
import de.justsoftware.onx.tasks.business.model.TaskListBO;
import de.justsoftware.onx.tasks.business.model.TaskListPublishingModel;
import de.justsoftware.onx.tasks.integration.persistence.TaskDAO;
import de.justsoftware.onx.tasks.shared.model.TaskId;
import de.justsoftware.onx.tasks.shared.model.TaskListId;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.curator.shaded.com.google.common.collect.Maps;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class TaskListServiceImpl
implements TaskListService {
    private final TaskDAO _taskDAO;
    private final TaskListPublisher _publisher;
    private final DeletionService _deletionService;
    private final JCEventBus _jcEventBus;

    @Autowired
    public TaskListServiceImpl(TaskDAO taskDAO, TaskListPublisher publisher, DeletionService deletionService, JCEventBus jcEventBus) {
        this._taskDAO = taskDAO;
        this._publisher = publisher;
        this._deletionService = deletionService;
        this._jcEventBus = jcEventBus;
    }

    @Override
    public TaskListId createTaskList(String name, Map<ProfileRole, TaskRight> permissions, TaskAuthorizationContext authCtx) {
        authCtx.check(TaskAction.TASK_LIST_CREATE);
        TaskListId id = new TaskListId(UUID.randomUUID());
        ImmutableMap<ProfileRole, TaskRight> correctedPerms = this.correctAndCheckTaskListPermissions(permissions, (ImmutableSet<ProfileRole>)ImmutableSet.of(), authCtx);
        this._taskDAO.insertTaskList(id, name, (Map<ProfileRole, TaskRight>)correctedPerms);
        this.postAddedToTaskListEvent(id, name, permissions, (ImmutableSet<ProfileRole>)ImmutableSet.of(), authCtx);
        this._publisher.publish(new TaskListPublishingModel(id, authCtx.getPersonId(), (ImmutableSet<ProfileRole>)ImmutableSet.copyOf((Collection)correctedPerms.keySet())));
        return id;
    }

    @Override
    public void updateTaskList(TaskListId taskListId, String name, Map<ProfileRole, TaskRight> permissions, TaskAuthorizationContext authCtx) {
        authCtx.check(taskListId, TaskAction.TASK_LIST_MANAGE);
        ImmutableSet currentPermissions = this._taskDAO.getTaskListPermissions((Set<TaskListId>)ImmutableSet.of((Object)taskListId)).row((Object)taskListId).keySet();
        ImmutableMap<ProfileRole, TaskRight> correctedPerms = this.correctAndCheckTaskListPermissions(permissions, (ImmutableSet<ProfileRole>)currentPermissions, authCtx);
        this._taskDAO.updateTaskList(taskListId, name, (Map<ProfileRole, TaskRight>)correctedPerms);
        this.postAddedToTaskListEvent(taskListId, name, permissions, (ImmutableSet<ProfileRole>)currentPermissions, authCtx);
        this._publisher.publish(new TaskListPublishingModel(taskListId, authCtx.getPersonId(), (ImmutableSet<ProfileRole>)ImmutableSet.copyOf((Collection)correctedPerms.keySet())));
    }

    @Nonnull
    private ImmutableMap<ProfileRole, TaskRight> correctAndCheckTaskListPermissions(Map<ProfileRole, TaskRight> permissions, ImmutableSet<ProfileRole> currentPermissions, TaskAuthorizationContext authCtx) {
        ImmutableSet diff = (ImmutableSet)Sets.difference(permissions.keySet(), currentPermissions).stream().map(ProfileRole::getPersonId).collect(ImmutableSet.toImmutableSet());
        authCtx.checkProfileVisibility((ImmutableSet<PersonId>)diff);
        ImmutableMap.Builder correctedPerms = ImmutableMap.builder();
        ProfileRole ownerRole = new ProfileRole(authCtx.getPersonId());
        correctedPerms.put((Object)ownerRole, (Object)TaskRight.MANAGE);
        correctedPerms.putAll(Maps.filterKeys(permissions, role -> !ownerRole.equals(role)));
        return correctedPerms.build();
    }

    private void postAddedToTaskListEvent(TaskListId listId, String name, Map<ProfileRole, TaskRight> permissions, ImmutableSet<ProfileRole> currentPermissions, TaskAuthorizationContext authCtx) {
        PersonId executorId = authCtx.getPersonId();
        ImmutableSet addedPersonIds = (ImmutableSet)Sets.difference(permissions.keySet(), currentPermissions).stream().map(ProfileRole::getPersonId).filter(personId -> !executorId.equals(personId)).collect(ImmutableSet.toImmutableSet());
        if (!addedPersonIds.isEmpty()) {
            this._jcEventBus.post(new AddedToTaskListEvent(listId, name, executorId, (ImmutableSet<PersonId>)addedPersonIds));
        }
    }

    @Override
    public ImmutableList<TaskListBO> getTaskListsForPerson(PersonId person) {
        return this._taskDAO.getTaskListsWithRoles((Set<ProfileRole>)ImmutableSet.of((Object)new ProfileRole(person)));
    }

    @Override
    public ImmutableMap<TaskListId, TaskListBO> getTaskLists(Set<TaskListId> taskListIds) {
        return this._taskDAO.getTaskListsByIds(taskListIds);
    }

    @Override
    public ImmutableTable<TaskListId, ProfileRole, TaskRight> getTaskListPermissions(Set<TaskListId> taskListIds) {
        return this._taskDAO.getTaskListPermissions(taskListIds);
    }

    @Override
    public void deleteTaskList(TaskListId taskListId, PersonId actor) {
        this._deletionService.deleteInTransactionWithDeleteAction(taskListId, actor, (s, d) -> {
            ImmutableSet<TaskId> tasks = this._taskDAO.getTaskIdsByTaskFilter(new TaskFilter("", null, null, null, null, taskListId));
            this._taskDAO.deleteTasksAndSubtasks((Set<TaskId>)tasks);
            this._taskDAO.deleteTaskLists((Set<TaskListId>)ImmutableSet.of((Object)taskListId));
            return null;
        });
    }
}

