/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.tasks.business.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.LongNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.google.common.collect.FluentIterable;
import de.justsoftware.onx.tasks.business.model.TaskListPublishingModel;
import java.util.Collection;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class TaskListPublisher {
    private static final String TASK_LIST_DATA_TOPIC = "just.tasks.lists";
    private static final Logger LOG = LoggerFactory.getLogger(TaskListPublisher.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private final Producer<String, String> _kafkaProducer;

    @Autowired
    public TaskListPublisher(@Nullable @Qualifier(value="KAFKA_STRING_PRODUCER") Producer<String, String> kafkaStringProducer) {
        this._kafkaProducer = kafkaStringProducer;
    }

    private void logErrorCallback(RecordMetadata metadata, Exception exception) {
        if (exception != null) {
            LOG.error("Could not publish task list to topic " + metadata.topic(), (Throwable)exception);
        }
    }

    public void publish(TaskListPublishingModel model) {
        if (this._kafkaProducer == null) {
            return;
        }
        try {
            ObjectNode jsonNode = OBJECT_MAPPER.createObjectNode();
            jsonNode.set("executor", (JsonNode)TextNode.valueOf((String)String.valueOf(model.getExecutor().getId())));
            jsonNode.set("roles", (JsonNode)OBJECT_MAPPER.createArrayNode().addAll((Collection)FluentIterable.from(model.getRoles()).transform(role -> LongNode.valueOf((long)role.getPersonId().getId())).toSet()));
            this._kafkaProducer.send(new ProducerRecord(TASK_LIST_DATA_TOPIC, (Object)model.getId().asString(), (Object)OBJECT_MAPPER.writeValueAsString((Object)jsonNode)), this::logErrorCallback);
        }
        catch (JsonProcessingException ex) {
            LOG.error(ex.getMessage(), (Throwable)ex);
        }
    }
}

