/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.tasks.business.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.common.business.events.JCEventBus;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.server.TransactionHelper;
import de.justsoftware.onx.common.shared.server.util.TokenUtilServer;
import de.justsoftware.onx.common.shared.util.EntityLinkUtil;
import de.justsoftware.onx.common.shared.util.StringUtil;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.ItemId;
import de.justsoftware.onx.kafka.AbstractKafkaConsumer;
import de.justsoftware.onx.kafka.KafkaConfigurationProvider;
import de.justsoftware.onx.kafka.KafkaConsumerContext;
import de.justsoftware.onx.tasks.business.TaskService;
import de.justsoftware.onx.tasks.business.events.RecommendationTaskAssignedEvent;
import de.justsoftware.onx.tasks.business.events.TaskAssignedEvent;
import de.justsoftware.onx.tasks.business.model.TaskBO;
import de.justsoftware.onx.tasks.shared.model.TaskId;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class TaskAssignmentNotificationCreator
extends AbstractKafkaConsumer<String, String> {
    private static final int MAX_DAYS_TO_PROCESS = 7;
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskAssignmentNotificationCreator.class);
    private final TaskService _taskService;
    private final JCEventBus _eventBus;

    @Autowired
    public TaskAssignmentNotificationCreator(TransactionHelper transactionHelper, KafkaConfigurationProvider kafkaConfigurationProvider, TaskService taskService, JCEventBus eventBus) {
        super(kafkaConfigurationProvider.stringConsumer("just.toro.TaskAssignmentNotificationCreator"), transactionHelper, "just.tasks.assignments");
        this._taskService = taskService;
        this._eventBus = eventBus;
    }

    @Override
    protected Logger getLog() {
        return LOGGER;
    }

    @Override
    protected void process(ConsumerRecords<String, String> records, KafkaConsumerContext context) {
        for (ConsumerRecord record : records) {
            LOGGER.info("consuming record: {}", (Object)record);
            String key = (String)record.key();
            JsonNode json = this.parseJson((String)record.value());
            if (key == null || json == null) continue;
            this.process(key, json, new DateTime(record.timestamp()));
        }
    }

    @VisibleForTesting
    void process(String taskId, JsonNode assignment, DateTime createdAt) {
        ItemId parsedId = ItemId.parseSafe(taskId);
        if (parsedId == null || !(parsedId instanceof TaskId)) {
            LOGGER.warn("The Id received from Kafka is not a TaskId: {}", (Object)taskId);
            return;
        }
        TaskId parsedTaskId = (TaskId)parsedId;
        if (createdAt.isBefore((ReadableInstant)DateTime.now().minusDays(7))) {
            return;
        }
        PersonId assignor = PersonId.parse((String)TaskAssignmentNotificationCreator.parseString(assignment, "assignor").orNull());
        if (assignor == null) {
            LOGGER.warn("Missing assignor field in json {}", (Object)assignment);
            return;
        }
        PersonId assignee = PersonId.parse((String)TaskAssignmentNotificationCreator.parseString(assignment, "assignee").orNull());
        if (assignee != null && !assignee.equals(assignor)) {
            this.process(parsedTaskId, assignor, assignee);
        }
    }

    private void process(TaskId taskId, PersonId assignor, PersonId assignee) {
        EntityId recommendation;
        TaskBO taskBO = (TaskBO)this._taskService.getTasks((Set<TaskId>)ImmutableSet.of((Object)taskId)).get((Object)taskId);
        if (taskBO == null) {
            return;
        }
        String attachmentUrl = taskBO.getAttachmentUrl();
        EntityId entityId = recommendation = StringUtil.isEmpty(attachmentUrl) ? null : EntityLinkUtil.parseEntityLink(attachmentUrl, TokenUtilServer.INSTANCE);
        if (recommendation != null) {
            this._eventBus.post(new RecommendationTaskAssignedEvent(taskId, assignor, assignee, recommendation, taskBO.getDescription()));
        } else {
            this._eventBus.post(new TaskAssignedEvent(taskId, taskBO.getName(), assignor, assignee));
        }
    }
}

