/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.tasks.authorization.impl;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import de.justsoftware.onx.tasks.authorization.TaskItemHandler;
import de.justsoftware.onx.tasks.authorization.model.TaskItem;
import de.justsoftware.onx.tasks.business.model.TaskBO;
import de.justsoftware.onx.tasks.integration.persistence.TaskDAO;
import de.justsoftware.onx.tasks.shared.model.TaskId;
import de.justsoftware.onx.util.shared.NullPermeableFunction;
import java.util.Map;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@ParametersAreNonnullByDefault
@Service
public class TaskItemHandlerImpl
implements TaskItemHandler {
    private final TaskDAO _taskDao;

    @Autowired
    public TaskItemHandlerImpl(TaskDAO taskDao) {
        this._taskDao = taskDao;
    }

    @Override
    public Map<TaskId, TaskItem> getByIds(ImmutableSet<TaskId> ids) {
        return Maps.transformValues(this._taskDao.getTasksByIds((Set<TaskId>)ids), (Function)new NullPermeableFunction<TaskBO, TaskItem>(){

            @Override
            protected TaskItem applySafe(TaskBO input) {
                return new TaskItem(input);
            }
        });
    }
}

