/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.survey.shared.server.model;

import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import de.justsoftware.onx.common.shared.model.component.ComponentType;
import de.justsoftware.onx.common.shared.model.component.StaticComponentType;
import de.justsoftware.onx.container.shared.model.GlobalId;
import de.justsoftware.onx.container.shared.server.model.Item;
import de.justsoftware.onx.container.shared.server.model.ItemVisitor;
import de.justsoftware.onx.survey.shared.model.DBSurvey;
import de.justsoftware.onx.survey.shared.model.SurveyId;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SurveyItem
implements Item<SurveyId> {
    public static final Function<DBSurvey, SurveyItem> FROM_DBSURVEY = new Function<DBSurvey, SurveyItem>(){

        public SurveyItem apply(DBSurvey input) {
            return SurveyItem.of(input);
        }
    };
    private final DBSurvey _survey;

    public SurveyItem(@Nonnull DBSurvey survey) {
        this._survey = survey;
    }

    @CheckForNull
    public static SurveyItem of(@Nullable DBSurvey survey) {
        return survey != null ? new SurveyItem(survey) : null;
    }

    @Nonnull
    public DBSurvey getSurvey() {
        return this._survey;
    }

    @Override
    public SurveyId getId() {
        return this._survey.getId();
    }

    @Override
    public GlobalId getParentId() {
        return this._survey.getParentId();
    }

    @Override
    public ComponentType getModuleType() {
        return StaticComponentType.SURVEY;
    }

    @Override
    public <T> T accept(ItemVisitor<T> v) {
        return v.visit(this);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("survey", (Object)this._survey).toString();
    }
}

