/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.survey.shared.model;

import com.freiheit.toro.common.shared.model.ValidationException;
import de.justsoftware.onx.common.shared.util.Numbers;
import de.justsoftware.onx.common.shared.util.StringUtil;
import de.justsoftware.onx.survey.shared.i18n.SurveyConstants;
import de.justsoftware.onx.survey.shared.i18n.SurveyMessages;
import de.justsoftware.onx.survey.shared.model.DBSurveyParticipantAnswer;
import de.justsoftware.onx.survey.shared.model.DBSurveyQuestion;
import java.util.Collection;
import java.util.List;

public final class SurveyParticipantAnswerValidator {
    private SurveyParticipantAnswerValidator() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void validate(DBSurveyQuestion question, List<DBSurveyParticipantAnswer> answer, SurveyConstants surveyConstants, SurveyMessages surveyMessages) throws ValidationException {
        int max;
        int min = Numbers.intValue(question.getMinAnswers());
        int answerSize = SurveyParticipantAnswerValidator.getSizeNullSafe(answer);
        for (DBSurveyParticipantAnswer a : answer) {
            if (!question.isFreetextAnswer() && !StringUtil.isBlank(a.getFreetextAnswer())) {
                throw new ValidationException("Illegal state: We got a freetext Answers but the question is not a freetext question");
            }
            if (question.getId().equals(a.getQuestionId())) continue;
            throw new ValidationException("Illegal state: The answers question Id is not equals the question id of the depending questions");
        }
        if (question.isFreetextAnswer()) {
            if (answerSize < 0 || answerSize > 1) throw new ValidationException("Illegal state: Multiple freetext Answers are not possible");
            if (min <= 0) return;
            if (answerSize == 0) {
                throw new ValidationException(surveyConstants.pleaseEnterAFreetextAnswerValidationErrorMsg());
            }
            if (StringUtil.isBlank(answer.get(0).getFreetextAnswer())) {
                throw new ValidationException(surveyConstants.pleaseEnterAFreetextAnswerValidationErrorMsg());
            }
            if (answer.get(0).getMultipleChoiceAnswerId() == null) return;
            throw new ValidationException("Illegal state: Multiple choice anwers found for a freetext questions");
        }
        int n = max = question.getMaxAnswers() == null ? question.getMultipleChoiceAnswers().size() : question.getMaxAnswers().intValue();
        if (max == min && answerSize != max) {
            throw new ValidationException(surveyMessages.selectExactlyXAnswers(max));
        }
        if (min <= answerSize && max >= answerSize) return;
        throw new ValidationException(surveyMessages.selectMinXAndMaxYAnswers(min, max));
    }

    private static int getSizeNullSafe(Collection<?> collection) {
        return collection == null ? 0 : collection.size();
    }
}

